# 1. はじめに

Rhopoint Aesthetix測定システムは、Aesthetix測定センサー、Rhopoint Appearance Elementsソフトウェア、およびオプションのAPIインターフェースで構成されています。

このヘルプガイドでは、機器の接続、ソフトウェアの操作方法、ワークフローへの統合方法、および測定結果を製品やプロセスの改善に活用する方法について説明します。

## 人間の視覚を再現するAesthetix測定

Aesthetixシステムは、高度なイメージング技術を使用して、表面と光との相互作用を精密に分析します。

制御された照明条件下でHD高解像度画像を取得することにより、人間の視覚に極めて近い方法で表面外観を定量化し、表面品質や視覚特性に関する重要な洞察を提供します。

## モジュール形式のソフトウェア

Aesthetixシステムのモジュール形式は、高い柔軟性とコスト効率を提供します。

ユーザーは必要な測定機能のみを選択して購入できるため、初期投資を抑えることができます。

また、このアプローチにより追加機能や将来の測定モジュールにも簡単にアクセスできるため、変化するニーズに合わせてシステムを進化させることが可能です。

モジュール式設計により、Aesthetixは幅広い用途で拡張性と適応性の高いソリューションとなっています。

- **表面ブリリアンスモジュール**：光沢（グロス）、ヘイズ（曇り）、DOI（鮮映度）、ウェービネス（ゆず肌）、視覚的光沢（Visual Gloss）を測定します。高光沢表面の反射品質と視覚的魅力を評価するために使用されます。
- **[エフェクト顔料モジュール](Effects-Finish-Module-ja.md)**：メタリックおよびパール顔料の外観を分析し、一貫した鮮やかな効果を確保します。
- **[表面テクスチャモジュール](Texture-Module-ja.md)**：テクスチャ表面の粗さ、セル振幅・サイズ、および山谷間反射特性を取得し、均一性と品質を確保します。
- **[研磨品質モジュール](Polishing-Quality-Module-ja.md)**：光沢度、ヘイズ、研磨欠陥および傷を同時に測定し、研磨プロセスの最適化と一貫した仕上がり品質を確保します。
- **[クロスカット密着性モジュール](Crosscut-Module-ja.md)**：密着性試験結果を客観的かつ再現可能な形で定量化し、塗料やコーティング剤の適合性および耐久性を確認します。
- **特注測定モジュール**：エンドユーザー固有の要件に正確に対応した特注測定モジュールも提供しています。

## 平面および曲面部品の測定

Aesthetixシステムは、平面部品、曲面部品、小さな領域を対象としており、接触式および非接触式両方の方法で評価できます。

## 多彩な統合オプション

Aesthetixはポータブルデバイスとして使用できるほか、固定設備への組み込みやロボットによる操作、生産ライン内で直接測定センサーとして機能させることも可能です。

## 強力なソフトウェア - 結果の共有・保存・分析

Rhopoint Appearance ElementsソフトウェアはRhopoint Aesthetixシステムに不可欠であり、高度な画像解析機能、結果データベース、クラウドデータストレージ、および包括的な結果分析・レポート作成機能が統合されています。この強力な組み合わせにより効率的なデータ管理と詳細な表面品質評価が可能になります。

## オプションのAPI統合

Rhopoint Appearance ElementsソフトウェアはオプションでAPI統合機能を提供しており、既存システムとのシームレスな連携が可能です。これによりデータ取得・分析・レポート作成プロセスを自動化し、表面品質評価業務の効率化が図れます。
