# ウェービネス (Waviness)

## **ウェービネスとは何か？**

ウェービネスは、滑らかなはずの表面に見られる穏やかな起伏や波状の形状を指します。コーティングされた表面では、この効果は「オレンジピール」と呼ばれることが多く、そのテクスチャがオレンジの皮に似ていることから名付けられています。

- **原因**: ウェービネスは、材料表面に存在する大きな構造（0.1〜10mm）によって引き起こされる光学効果です。
- **高光沢仕上げへの影響**: 過剰なウェービネスは反射画像の均一性と明瞭さを妨げるため、知覚品質を低下させます。
- **重要性**: 高光沢コーティングの外観品質を評価する際、ウェービネスは重要なパラメータです。滑らかで低ウェービネスのコーティングは、より高品質と認識されます。

---

## **Aesthetixによるウェービネスの測定方法**

Rhopoint Aesthetixは、材料表面に反射された25mmの直線の歪みを定量化することでウェービネスを測定します。

- **測定プロセス**: Aesthetixは反射画像を分析し、表面の起伏が反射光に与える影響を評価します。
- **用途**: ウェービネス測定は、自動車塗装、金属加工、コーティングされた表面など、高光沢仕上げが求められる業界で特に重要です。

---

## **ウェービネスと人間の知覚**

ウェービネスは、高光沢コーティングの外観品質を評価する際に観察者が使用する重要な指標です。

- **知覚品質への影響**: 滑らかで低ウェービネスの表面は、高い品質として認識されます。一方で、より多くのテクスチャ（高ウェービネス）を持つ類似の表面は、知覚品質が低下します。
- **オレンジピール効果**: 不適切な塗装技術や環境条件などが原因で発生し、表面品質を損ないます。

---

## **ウェービネス測定の重要性**

ウェービネス測定は以下の目的で使用されます:
1. **品質管理**: 表面の滑らかさと視覚的魅力を維持するため。
2. **製造プロセスの最適化**: 塗装パラメータを調整し、オレンジピール効果を最小限に抑えるため。
3. **コスト削減**: 過剰処理を回避しながら、合意された仕様を満たすため。
4. **隣接部品との調和**: 異なる基材や塗装プロセスによる視覚的な違いを回避するため。

---

## **ウェービネスレベルとその意味**

| ウェービネス値 | 表面           | 説明/知覚                                   |
|---------|--------------|-----------------------------------------|
| 2       | ピアノ仕上げ       | 非常に滑らかで目に見えるウェービネスなし。非常に高品質な印象を与える。     |
| 2-5     | 低オレンジピール     | 滑らかな仕上げ—オレンジピールはほとんど見えず、中立的または良好な印象。    |
| 5-10    | 標準的なオレンジピール  | 中程度のオレンジピールが見え、特に黒など高コントラスト色では仕上げ品質に影響。 |
| 5-15    | 高オレンジピール     | 顕著なオレンジピールがあり、表面品質評価に悪影響を与える可能性。        |
| >15     | 非常に高いオレンジピール | 表面がテクスチャ化されて見え、表面品質評価に非常に悪い影響。          |

---

ウェービネス測定は、高光沢製品の視覚的品質を向上させるために不可欠です。Rhopoint Aesthetixは、人間の知覚と一致する精密な測定値を提供し、製品開発および品質管理プロセスにおいて重要な役割を果たします。
