# Waviness Interpretation

## Waviness Values and Their Meaning

The Aesthetix waviness scale is highly correlated to Rhopoint TAMS waviness - a measurement parameter derived from multiple human perception trials.

The value quantifies the visual impact of orange peel observed in high gloss coatings at a viewing distance of 1.5m.

This value has been proven effective for quantifying orange peel in sectors such as automotive, yacht Coatings, powder coatings and high quality furniture.

## Waviness values and their meanings:

- 2 WU: Piano Finish - Very smooth with no visible waviness. Imparts a feeling of very high quality.
- 2-5 WU: Low orange peel - Smooth finish, orange peel is barely visible with a good or neutral impact on judgement of surface finish.
- 5-10 WU: Standard Orange Peel - Surface with moderate orange-peel which is visible and is a factor when judging finish quality, especially on high contrast colors (black).
- 10-15 WU: High Orange peel - Surface with prominent orange peel which has a negative impact on surface quality judgement.



## Visualizing Waviness Using Appearance Elements

## Changing the Waviness of a Surface

To change the waviness of a surface:

1. Improve Application Technique: Proper spraying distance, angle, and technique can reduce uneven paint distribution that leads to orange peel.
2. Adjust Paint Viscosity: Use paint with the correct viscosity for better flow and leveling, reducing bumpy finishes.
3. Control Environmental Factors: Maintain appropriate humidity and temperature during application and drying to prevent uneven drying that can cause orange peel.
4. Enhance Surface Preparation: Adequate sanding and cleaning of the surface before painting can minimize imperfections that contribute to waviness.
5. Allow Proper Curing Time: Sufficient drying time between coats can result in a more even surface texture.
6. Optimize Equipment Settings: Use the correct nozzle size and pressure settings on spray guns for proper paint atomization.
7. Address Substrate Issues: Improve the underlying material quality, as texture in the substrate can telegraph through the coating layers, causing visible orange peel[^1].

Remember that changing waviness may affect other surface properties, so consider the overall impact on the product's appearance and performance when making adjustments.
