# ウェービネスの解釈

## **ウェービネス値とその意味**

Rhopoint Aesthetixのウェービネススケールは、複数の人間の知覚試験から得られたRhopoint TAMSウェービネスと高い相関関係を持っています。

この値は、1.5mの観察距離で高光沢コーティングにおけるオレンジピールの視覚的影響を定量化します。  
自動車、ヨットコーティング、粉体塗装、高品質家具など、さまざまな分野でオレンジピールを定量化するために効果的であることが証明されています。

---

## **ウェービネス値とその意味**

- **2 WU**: ピアノ仕上げ  
  非常に滑らかで目に見えるウェービネスがありません。非常に高品質な印象を与えます。
- **2-5 WU**: 低オレンジピール  
  滑らかな仕上げ—オレンジピールはほとんど目立たず、表面仕上げの評価に良好または中立的な影響を与えます。
- **5-10 WU**: 標準的なオレンジピール  
  中程度のオレンジピールが見られる表面。特に黒などの高コントラスト色では仕上げ品質評価に影響します。
- **10-15 WU**: 高オレンジピール  
  顕著なオレンジピールがあり、表面品質評価に悪影響を与える可能性があります。

---

## **Appearance Elementsによるウェービネスの視覚化**

<note>ウェービネス測定結果は、Rhopoint Appearance Elementsソフトウェアで視覚化され、分析できます。</note>

---

## **表面のウェービネスを変更する方法**

表面のウェービネスを改善するには以下を検討してください:

1. **塗布技術の改善**: 適切なスプレー距離、角度、技術を使用して塗料の不均一分布を減らし、オレンジピールを防ぎます。
2. **塗料粘度の調整**: 適切な粘度の塗料を使用することで流動性と平滑性を向上させ、不均一な仕上がりを減少させます。
3. **環境要因の管理**: 塗布および乾燥中に適切な湿度と温度を維持して、不均一な乾燥によるオレンジピールを防ぎます。
4. **表面準備の強化**: 塗装前に十分な研磨と清掃を行い、ウェービネスにつながる欠陥を最小限に抑えます。
5. **適切な硬化時間の確保**: コート間で十分な乾燥時間を確保することで、より均一な表面テクスチャが得られます。
6. **機器設定の最適化**: スプレーガンのノズルサイズと圧力設定を適切に調整して塗料の霧化を改善します。
7. **基材問題への対応**: 基材の品質を改善し、基材テクスチャがコーティング層に影響して目立つオレンジピールが発生することを防ぎます。

<tip>ウェービネス変更は他の表面特性にも影響する可能性があるため、製品外観や性能への全体的な影響を考慮してください。</tip>
