# Visual Haze

**Visual Haze**は、新しい測定基準で、照明条件や背景塗料の色を考慮することで、人間の知覚とより一致する感度と一貫性を実現します。

視覚的ヘイズは、背景色の輝度と鏡面反射近傍の輝度（ヘイズ）を考慮して計算されます。  
2つの値が提供され、室内観察条件と屋外の強い日光下での観察条件におけるヘイズの視認性を表します。

![2つのパネルの視覚的ヘイズ](two-panels-visual-haze.png)
<sup>反射特性が同一の2つのパネルですが、白い素材ではヘイズが視覚的に見えません。Visual Hazeは知覚されたヘイズを記録します。</sup>

<note>低コントラスト色で高い技術的ヘイズ (LogH C) が測定される場合、消費者には見えないことがありますが、仕様外と見なされる可能性があります。  
Visual Hazeは人間の知覚に一致し、不必要な材料拒否や過剰処理を回避するために使用されます。</note>

---

## **Visual Haze VH 室内 Vh<sub>in</sub> と Visual Haze 屋外 Vh<sub>out</sub>**

ヘイズ効果は強い日光下で増幅されます。屋内条件では見えない渦巻きやホログラムが、高強度光源で照らされると顕著になります。

![LogH Cで検出されない表面欠陥](surface-defects-not-detected-loghc.png)
<sup>技術的ヘイズ (LogH C) では検出されない表面欠陥が、強い日光下では非常に目立ちます。</sup>

Rhopoint Aesthetixは、作業場や晴天の屋外条件下で、ヘイズ、傷、研磨跡の視認性を予測できます。

|                  | 条件       | 表面照明     | 鏡面照明                  |
|------------------|----------|----------|-----------------------|
| VH<sub>in</sub>  | 標準的な室内照明 | 0.5k Lux | 25k cd/m<sup>2</sup>  |
| VH<sub>out</sub> | 晴天（快晴）   | 100k Lux | 1.6m cd/m<sup>2</sup> |

<note>屋外で使用されるコーティングや材料は、Visual Haze Outdoor (Vh<sub>out</sub>) パラメータを使用して評価する必要があります。これにより、すべての条件下で不要なヘイズの視認性を定量化し、顧客満足度や材料再加工を回避できます。</note>

---

## **ヘイズレベルとその意味**

| ヘイズ値             | 表面      | 説明/知覚                        |
|------------------|---------|------------------------------|
| <50 Hu (室内または屋外) | 高品質な表面  | ほぼ完璧な表面—通常の観察条件下ではヘイズは見えません。 |
| 50-100           | 超低ヘイズ表面 | 良好な仕上げ深度—反射光源周囲にわずかに見えるハロー。  |
| 100-250          | 可視的なヘイズ | 仕上げ深度が損なわれる—渦巻きや研磨跡が見える。     |
| 250-300          | ヘイズ表面   | 品質が低い仕上げ。                    |
| 300-500          | 品質が低い表面 | 顕著なハロー、ホログラムまたは研磨跡。仕上げ深度が悪い。 |

---

## **重要性**

- **室内条件**: Visual Haze Indoor (Vh<sub>in</sub>) は室内環境での材料評価に適しています。
- **屋外条件**: Visual Haze Outdoor (Vh<sub>out</sub>) は屋外環境で不要なヘイズの視認性を定量化し、不満や再加工を回避します。

この新しい測定基準は、人間の知覚に基づいており、特定条件下での製品品質評価において重要です。
