# Visual Haze
NEW Visual Haze measurement is more sensitive and more consistent with human perception because it accounts for illumination conditions and background paint colour. 

Visual haze is calculated considering the luminosity of the background colour and the luminosity of the near specular reflection (Haze). 
Two values are provided to account Haze visibility in two different viewing conditions, indoor viewing compared to outdoor viewing in strong sunlight.  

![Two panels visual haze](two-panels-visual-haze.png)
<sup>Two panels with identical reflective properties but Haziness is not visible on the white material. Visual Haze records the perceived haziness.</sup><br />

<note>High levels of technical haze (LogH C) on low contrast colours are not visible but may cause the material to fall outside of specification.
Visual Haze matches human perception and used to avoid unnecessary material rejections and over processing.</note>

## Visual Haze VH Indoor Vh<sub>in</sub> and Visual Haze Outdoor  Vh<sub>out</sub>
Haze effects are amplified in strong sunlight- swirls whirls and holograms which are not visible in indoor conditions  are prominent when illuminated by a high intensity light-source.

![Surface defects not detected by LogH C](surface-defects-not-detected-loghc.png)
Surface Defects which are not detected by technical haze (LogH C) are very visible in strong sunlight.
The Aesthetix can predict the visibility of haze, scratches and polishing marks in workshop and sunny outdoor conditions.

|                  | Conditions               | Surface illumination | Specular Illumination |
|------------------|--------------------------|----------------------|-----------------------|
| VH<sub>in</sub>  | Standard indoor lighting | 0.5k Lux             | 25k cd/m<sup>2</sup>  |
| VH<sub>out</sub> | Sunny day- clear sky     | 100k Lux             | 1.6m cd/m<sup>2</sup> |

<note>Coatings or materials which are to be viewed in outdoor conditions should be assessed using the Visual Haze Outdoor (Vhod) parameter- which will quantify the visibility of unwanted haziness in all conditions, avoiding customer dissatisfaction and material re-work.</note>

| Haze                       | Surface                | Description/Perception                                                    |
|----------------------------|------------------------|---------------------------------------------------------------------------|
| <50 Hu (Indoor or outdoor) | High Quality Surface   | Almost perfect surface- haze not visible under normal viewing conditions. |
| 50-100                     | Ultra Low Haze Surface | Good depth of finish- Barely visible halo around reflected light sources. |
| 100-250                    | Visible Haze           | Depth of finish is compromised- swirls and polishing marks are visible    |
| 250-300                    | Hazy Surface           | Poor quality finish                                                       |
| 300-500                    | Poor Quality Surface   | Prominent halos, holograms or polish marks. Poor depth of finish          |

