# 视觉雾影（Visual Haze）

**全新的视觉雾影测量方法更加敏感，并且与人眼感知更加一致**，因为它**考虑了照明条件和背景颜色对雾影的影响**。

视觉雾影的计算基于**背景颜色的亮度**以及**镜面反射（雾影）区域的亮度**。  
为了适应不同的观察环境，提供了**两种雾影测量值**：
- **室内视觉雾影（Vh<sub>in</sub>）**——适用于室内照明环境
- **室外视觉雾影（Vh<sub>out</sub>）**——适用于户外强光照明环境

![视觉雾影示例](two-panels-visual-haze.png)
<sup>两个具有相同反射特性的面板，但**白色材料上的雾影不可见**。  
视觉雾影测量可记录人眼感知的雾影情况。</sup><br />

<note>在**低对比度颜色的材料上，较高的技术雾影（LogH C）值通常肉眼不可见**，但可能导致材料不符合规格。  
**视觉雾影（VH）更符合人眼感知，可避免不必要的材料报废和过度加工。**</note>

---

## **视觉雾影测量：室内 Vh<sub>in</sub> 与室外 Vh<sub>out</sub>**

**强光照条件下，雾影现象更加明显**——  
**在强烈阳光下，可见的光晕、旋纹和抛光痕迹**，在室内环境中可能完全不可见。

![技术雾影 LogH C 无法检测到的表面缺陷](surface-defects-not-detected-loghc.png)
<sup>某些表面缺陷不会被**技术雾影（LogH C）**检测到，但在**阳光下非常明显**。  
Aesthetix 可预测**雾影、划痕和抛光痕迹**在车间和户外条件下的可见性。</sup>

|                  | 观察条件                 | 表面光照强度       | 镜面反射光强度         |
|------------------|-------------------------|-------------------|----------------------|
| VH<sub>in</sub>  | 标准室内照明            | 0.5k Lux          | 25k cd/m<sup>2</sup>  |
| VH<sub>out</sub> | 晴天、无云环境          | 100k Lux         | 1.6M cd/m<sup>2</sup> |

<note>**需要在户外环境下使用的涂层或材料**，应采用**视觉雾影（Vh<sub>out</sub>）**进行评估。  
该参数可量化雾影在各种环境中的可见性，从而**避免客户投诉和材料返工**。</note>

---

## **视觉雾影数值与表面质量的关系**

| 雾影值（Hu）                  | 表面质量               | 视觉感知描述                                                   |
|-------------------------------|------------------------|----------------------------------------------------------------|
| <50  （室内或室外）           | **高质量表面**         | 表面几乎完美，**在正常观察条件下雾影不可见**。                 |
| 50-100                        | **超低雾影表面**       | 具有良好的光泽深度，仅在**反射光源周围轻微可见光晕**。           |
| 100-250                       | **可见雾影**           | **光泽深度受损**，旋纹和抛光痕迹变得**明显可见**。              |
| 250-300                       | **雾影明显的表面**     | **表面质量较差**，光泽感受到较大影响。                          |
| 300-500                       | **低质量表面**         | **明显的光晕、抛光痕迹或全息图效应**，光泽深度极差。            |
