# Visual Gloss

Visual Gloss (VGU): A NEW measurement which matches gloss perception of  human observers when comparing surfaces of different colour.

Gloss perception of high gloss surfaces is influenced not only by the intensity of the reflected light but also the background colour of the material it is reflected in.

![Gloss car example](gloss-car-example.png)
<sup>Materials with a dark background appear glossier to a human observer than the same amount of reflection on a material with a light background.</sup><br />

## Visual Gloss Scale
The scale for Visual Gloss (VGU) was obtained through psychophysical experiments where human observers rated the glossiness of various samples under controlled lighting conditions. 

Experiments involved a light booth with adjustable specular and background light sources, and samples with different back painted colours and various gloss levels.  

Observers used a method called magnitude estimation to assess the glossiness of each sample, comparing them to a standard reference with a predefined gloss value.

## Visual Gloss and Human Perception
The VGU equation was derived from the psychophysical experiments showed a high degree of correlation with human perception of gloss, the equation predicts visual gloss (VG) based on the contrast between the brightness of the reflected image against the background colour of the surface. 

The performance of the Visual Gloss prediction formula was evaluated using a psychophysical scaling function, and it achieved a high adjusted coefficient of determination (r2 =0.963).

## Visual Gloss Measurement
The Aesthetix measures Visual Gloss (VGU) using dual cameras and a combination of light sources, images of the sample are captured under direct illumination by the specular source and background illumination provided by the 45 degree circumferential ring light. 

The visual gloss algorithm calculates considers intensity of the specular highlight viewed against the luminance of the background viewed in indoor conditions.

![Sample luminance and background color](sample-luminance-background-color.png)
<sup>The Rhopoint Aesthetix measures Visual gloss with images from the specular and observer camera.</sup><br />

## Visual Gloss Validated
The Aesthetix method for calculating visual gloss was validated using  an Imaging Luminance Measurement Device (ILMD), mathematical modelling and ray-tracing simulations. 

Results were empirical tested using diverse samples from a commercial gloss scale.

This validation demonstrated a strong correlation between the Aesthetix measurements and the contrast gloss formula, particularly effective in mid to high gloss ranges. 

