# 视觉光泽度（Visual Gloss）

**视觉光泽度（VGU）**：一种全新的测量方法，可**准确匹配人眼对不同颜色表面光泽度的感知**。

**高光泽表面的光泽感知不仅取决于反射光的强度，还受到材料背景颜色的影响。**

![光泽度汽车示例](gloss-car-example.png)
<sup>人眼观察时，**深色背景的材料比浅色背景的材料显得更光亮**，即使它们的反射光强度相同。</sup><br />

---

## **视觉光泽度量表**

**视觉光泽度（VGU）量表**是通过**心理物理实验**建立的，该实验让观察者在**受控光照条件下**对不同样品的光泽度进行评级。

- **实验条件**：
    - 采用**光照测试箱**，可调节**镜面反射光源**和**背景光源**。
    - 测试样品具有不同的**底漆颜色**和**光泽水平**。

- **评估方法**：
    - 观察者使用**数量估计法（Magnitude Estimation）**评估每个样品的光泽度。
    - 测量结果与**预设标准光泽度**进行比较，以建立**人眼感知光泽度量表**。

---

## **视觉光泽度与人类感知**

VGU 公式源自心理物理实验，实验结果表明其与**人眼感知光泽度高度相关**。  
**VGU 计算公式**基于**镜面反射区域的亮度**与**背景颜色的亮度对比**来预测视觉光泽度（VG）。

- **VGU 预测公式的验证**：
    - 通过**心理物理尺度分析函数**进行评估，最终调整后的**决定系数（r² = 0.963）**，表明 VGU 预测与人眼感知光泽高度匹配。

---

## **视觉光泽度测量方法**

Aesthetix 采用**双摄像头和组合光源**测量视觉光泽度（VGU）：

1. **镜面光源（Specular Source）**：用于直接照射样品，测量镜面反射区域的亮度。
2. **45° 环形背景光源（Circumferential Ring Light）**：提供背景照明，以测量表面的背景亮度。
3. **双摄像头成像**：
    - **镜面摄像头（Specular Camera）**：捕捉高光反射图像。
    - **观察摄像头（Observer Camera）**：测量背景亮度。

![样品亮度与背景颜色](sample-luminance-background-color.png)
<sup>Rhopoint Aesthetix 通过**镜面摄像头和观察摄像头**测量视觉光泽度。</sup><br />

---

## **视觉光泽度测量方法的验证**

Aesthetix 的**视觉光泽度计算方法**经过以下验证：

1. **成像亮度测量设备（ILMD）**：通过精确成像测量表面亮度分布。
2. **数学建模与光线追踪仿真（Ray-Tracing Simulations）**：模拟不同光泽水平的光线反射特性。
3. **商业光泽度标准样品测试**：
    - 使用商业光泽度量表进行**实证测试**，结果表明 Aesthetix 测量方法与**对比光泽度公式**（Contrast Gloss Formula）高度一致。
    - **在中高光泽度范围内，Aesthetix 方法的准确性尤为突出**。

---
