# 視覚的光沢 (Visual Gloss)

**視覚的光沢 (VGU)** は、新しい測定基準であり、異なる色の表面を比較する際に人間の観察者の光沢知覚と一致します。

高光沢表面の光沢知覚は、反射光の強度だけでなく、それが反射される材料の背景色にも影響されます。

![光沢車の例](gloss-car-example.png)
<sup>暗い背景を持つ材料は、同じ反射量を持つ明るい背景の材料よりも、人間の観察者にとって光沢があるように見えます。</sup>

---

## **視覚的光沢スケール**

視覚的光沢 (VGU) のスケールは、心理物理学的実験を通じて得られました。この実験では、人間の観察者が制御された照明条件下でさまざまなサンプルの光沢を評価しました。

- 実験では、調整可能な鏡面および背景光源を備えたライトブースを使用し、異なる色で塗装されたサンプルとさまざまな光沢レベルをテストしました。
- 観察者は「マグニチュード推定法」を使用して各サンプルの光沢を評価し、事前に定義された標準値を持つ基準と比較しました。

---

## **視覚的光沢と人間の知覚**

VGU方程式は心理物理学的実験から導出され、人間の光沢知覚と高い相関関係を示しました。この方程式は、表面の背景色に対する反射画像の明るさとのコントラストに基づいて視覚的光沢 (VG) を予測します。

- 視覚的光沢予測式は心理物理学的スケーリング関数を使用して評価され、高い調整済み決定係数 (\( r^2 = 0.963 \)) を達成しました。

---

## **視覚的光沢測定**

Rhopoint Aesthetixは、デュアルカメラと複数の光源を使用して視覚的光沢 (VGU) を測定します。

- サンプル画像は、鏡面光源による直接照明と45度環状リングライトによる背景照明下で取得されます。
- 視覚的光沢アルゴリズムは、屋内条件で観察される背景輝度に対する鏡面ハイライトの強度を考慮して計算されます。

![サンプル輝度と背景色](sample-luminance-background-color.png)
<sup>Rhopoint Aesthetixは、鏡面カメラと観察者カメラから得られる画像を使用して視覚的光沢を測定します。</sup>

---

## **視覚的光沢の検証**

Rhopoint Aesthetixによる視覚的光沢計算方法は以下を用いて検証されました:
1. 画像輝度測定装置 (ILMD)
2. 数学モデリング
3. レイトレーシングシミュレーション

- 検証には商業用グロススケールから多様なサンプルが使用されました。
- この検証により、Aesthetix測定値とコントラストグロス式との強い相関が示され、とりわけ中〜高光沢範囲で効果的であることが確認されました。
