# 結果の解釈 - 表面テクスチャ

## Rhopoint Aesthetix はどのように表面テクスチャを測定するのか？

Aesthetixは、高度な光学技術と計算技術を用いて表面テクスチャを測定します。このシステムは、**フォトメトリックステレオ撮影法**を使用し、表面法線を推定して詳細な3D地形マップを生成します。これらのマップは、表面の高さの変化を表しており、テクスチャの特徴を正確に解析できます。また、表面を個別のセル（凸部と凹部）に分割するために**ウォーターシェッドアルゴリズム**を使用し、高さ、サイズ、分布などの構造的特徴を定量化します。

測定プロセスの主な手順：

1. **画像取得**：異なる照明条件下で複数の画像を撮影し、表面法線を算出します。
2. **3D地形マップ生成**：表面の高さ変化を示す高さマップを作成します。
3. **セグメンテーション**：ウォーターシェッドアルゴリズムで特徴をセルに分割し、凸部や凹部および境界を特定します。
4. **解析**：得られたデータから粗さ、セル振幅、セルサイズ、反射率などの指標を算出します。

## Aesthetix が提供する表面テクスチャおよび反射率測定項目

Aesthetixは表面テクスチャと反射率を包括的に表すために以下の指標を提供します。

### テクスチャ指標

- **Sa（粗さ）**：表面の高さ変動の標準偏差。
- **Ca（セル振幅）**：凸部と凹部の平均高さ差（単位：知覚マイクロメートル p-µm）。
- **Cn（セル数）**：測定領域内の識別された特徴またはセルの総数。
- **Cs（セルサイズ）**：セルサイズの平均、最小、最大、および標準偏差（単位：mm²）。
- **Hs（凸部サイズ）**：凸部の平均断面積（単位：mm²）。

### 反射率指標

- **R（反射率）**：表面の平均反射率（任意単位）。
- **RC（反射コントラスト）**：凸部と凹部間の反射率差。
- **RH/RV**：凸部（RH）および凹部（RV）に特化した反射率。

### 比較と用途

- 表面の全体的な滑らかさを評価するには、一般的な粗さ指標である**Sa**を使用します。
- 触覚または視覚的な深さや立体感を評価するには、**Ca**を選択します。
- 特徴の密度や均一性（テクスチャコーティングや成形品に重要）を理解するには、**Cn**や**Cs**を使用します。
- テクスチャが視覚的なコントラストや光沢感にどのように影響するかを決定するには、反射率指標の**RC**が適しています。

用途に応じて指標を選択してください：

- 自動車内装のような均一性が求められる機能性表面の場合、**Cn**, **Cs**, および **RC** を重視します。
- レザー調仕上げなどの美観が重要な表面では、**Ca** や **Sa** を優先的に使用します。

## Appearance Elementsを用いた表面テクスチャの視覚化

Rhopoint Appearance Elementsソフトウェアを使用すると、表面テクスチャを詳細に視覚化・解析できます。次の手順で表面の3D構造や特徴を効果的に調べます：

1. **左側のウィンドウで3Dビューを開く**
    - ソフトウェア左側のパネルで「3Dビュー」タブを選択します。
    - 表面の地形マップが3Dモデルとして表示され、高さ変化を色分けで表します。
    - マウスまたはナビゲーションツールを使い、3Dマップを回転、ズーム、パンして包括的に観察できます。

2. **中央のマップウィンドウでプロファイルツールを使う**
    - 中央ウィンドウの「マップビュー」を選択し、表面の高さマップを2D表示します。
    - 「プロファイルツール」（通常ラインのアイコン）を選択します。
    - マップ上をクリック＆ドラッグして関心領域を示すラインを引きます。このラインが断面解析用のプロファイルになります。

3. **右側のウィンドウでプロファイルビューを開く**
    - 右側パネルで「プロファイルビュー」タブを選択します。
    - プロファイルビューには描かれたライン上の断面グラフが表示され、高さの変化が「知覚マイクロメートル（p-µm）」で示されます。
    - ピークは凸部、谷は凹部を示します。

4. **特徴ウィンドウでセルサイズを解析**
    - 右側パネルで「特徴ウィンドウ」を開きます。
    - このウィンドウではウォーターシェッドアルゴリズムで区切られたセル、凸部、凹部などの特徴が詳しく表示されます。
    - セルサイズ（平均、最小、最大）、セル振幅、高さ差、セル数などの指標を確認できます。これらはテクスチャの均一性、密度、深さ評価に役立ちます。

5. **表示設定を調整する**
    - 設定メニューでウォーターシェッドパラメータ（特徴の分離や選択など）を調整し、特徴検出を改善します。
    - 特定領域を強調するためのカラースケールやオーバーレイ表示を使用できます。

これらのツールを組み合わせることで、表面テクスチャの深さ、均一性、構造的特徴について詳細に理解できます。このプロセスは品質管理や製品開発、製造工程の一貫性確保に不可欠です。

## 表面テクスチャまたは反射率の調整

表面テクスチャを変更する方法：

1. **表面処理**
    - 研磨や研削で粗さ（**Sa**）を減らし、表面を滑らかにできます。
    - エンボス加工や化学エッチングで、テクスチャの立体感（**Ca**）を強調したり特定パターンを作れます。

2. **ツールの設計または摩耗**
    - セルサイズはツールの設計段階で決定されますが、ツール摩耗によりセルの深さや反射率が変化します（**Cn**, **Cs**, **R**, **RC**）。

Aesthetixの測定結果に基づいて適切な処理を選択することで、美観や機能性を実現し、製造ロット間での一貫性を維持できます。
