# Interpreting Results- Polishing Quality Module


## How Does Aesthetix Measure Polishing Quality (Scratches, Swirls, and Holograms)?

The Aesthetix evaluates polishing quality by using **high-resolution imaging and advanced algorithms** to detect and quantify surface defects such as scratches, swirls, and holograms. These imperfections are identified based on their unique visual characteristics under specific lighting conditions.

### Measurement Process:

1. **Directional Illumination**: The Aesthetix uses multiple light sources, including a **10° point light** and a **45° ring light**, to illuminate the surface. These lighting setups enhance the visibility of defects like scratches, swirls, and holograms.
2. **High-Resolution Imaging**: A camera captures detailed images of the illuminated surface. Scratches appear as linear features, swirls as concentric circular patterns, and holograms as elongated streaks starting from the light source.
3. **Image Analysis**: The system applies image segmentation algorithms to isolate and quantify these defects. Metrics such as defect length, width, density, and orientation are calculated.

This approach ensures precise detection of polishing defects that are often difficult to identify under standard inspection conditions.

---

## Additional Measurements Provided by Aesthetix

In addition to detecting scratches, swirls, and holograms, the Aesthetix provides several advanced metrics to further analyse surface quality:

1. **Sharpness**:
    - Measures the clarity and definition of edges in reflected images.
    - Higher sharpness values (measured in Sharpness Units [SU]) indicate clearer reflections with well-defined edges.
    - Useful for assessing overall surface quality and how well the surface reflects fine details.
2. **Distinctness of Image (DOI)**:
    - Evaluates the overall clarity of reflected images.
    - Higher DOI values indicate less distortion in reflections, making it ideal for applications requiring smooth finishes (e.g., automotive coatings).
3. **LogHaze C**:
    - Quantifies technical haze caused by light scattering around a specular reflection.
    - Important for identifying micro-textures or contaminants that reduce clarity.
4. **Visual Haze Outdoor (VHout)**:
    - Adjusts haze measurements to match human perception under outdoor lighting conditions.
    - Critical for applications where products are viewed in bright sunlight or high-intensity lighting environments.

### Comparison and Application:

- Use **Sharpness** for high-gloss surfaces where edge clarity is critical (e.g., automotive finishes or polished metals).
- Choose **DOI** when assessing the overall distinctness of reflections is more important than edge sharpness.
- Select **LogHaze C** for technical analysis of haze caused by micro-textures or contaminants.
- Opt for **Visual Haze Outdoor** when evaluating surfaces intended for outdoor use, ensuring defects like holograms or haze are not visible under sunlight.

Each metric provides unique insights into surface quality; selecting the right one depends on your specific application requirements.

---

## Visualising Polishing Quality Using Appearance Elements

The Rhopoint Appearance Elements software enables detailed visualisation of polishing quality:

1. **Open Defect View**:
    - Navigate to the "Defect View" tab in the software.
    - Use directional lighting options (e.g., 10° point light) to highlight surface imperfections.
2. **Analyse Defects**:
    - Scratches appear as linear features in the captured images.
    - Swirls are displayed as circular patterns, while holograms appear as elongated streaks.
    - Colour-coded overlays can be applied to distinguish between defect types.
3. **Visualise Advanced Metrics**:
    - Access additional views for Sharpness, DOI, LogHaze C, and Visual Haze Outdoor.
    - Compare these metrics side-by-side with defect visualisations to correlate numerical values with observed imperfections.
4. **Quantitative Analysis**:
    - View metrics such as scratch density, swirl intensity, sharpness units (SU), DOI values, and haze levels in the results panel.
    - Compare multiple samples side-by-side for consistency checks.
5. **Export Results**:
    - Save annotated images and data for reporting or further analysis.

---

## Improving Polishing Quality (Reducing Visibility of Scratches, Swirls, and Holograms)

To improve polishing quality and reduce visible defects:

1. **Optimise Polishing Techniques**:
    - Use finer abrasives or polishing compounds to minimise scratches.
    - Avoid excessive pressure during rotary polishing to reduce swirl marks.
    - Use dual-action polishers instead of rotary tools to prevent holograms.
2. **Control Environmental Factors**:
    - Ensure a clean workspace to avoid introducing dust or debris during polishing.
    - Maintain consistent temperature and humidity to optimise compound performance.
3. **Use High-Quality Materials**:
    - Select premium polishing pads and compounds designed for specific surface types.
    - Ensure compatibility between pads, compounds, and coatings.
4. **Inspect Regularly During Polishing**:
    - Periodically check surfaces under directional lighting to identify defects early.
    - Adjust techniques or materials as needed based on real-time feedback.
5. **Apply Protective Coatings**:
    - Use sealants or ceramic coatings after polishing to protect against future scratches or defects.

By leveraging precise measurements from Aesthetix alongside these improvement strategies, manufacturers can achieve consistently high-quality finishes with minimal visible imperfections while ensuring alignment with human perception under various lighting conditions.
