# 结果解析 - 效果颜料模块

## Rhopoint Aesthetix 如何测量闪烁感和颗粒感？

Aesthetix 采用**先进的成像技术**，在特定照明条件下捕捉表面反射，以测量**闪烁感（Sparkle）**和**颗粒感（Graininess）**。

- **闪烁感测量**：
    - 通过分析**显著高于周围背景亮度的亮点（闪烁点）**来量化闪烁感。
    - 系统使用多个**45° 角光源**以及单个**10° 角光源**拍摄高动态范围图像。
    - 计算**闪烁点的可见性、密度和大小**，基于**亮度对比度、光点分布和空间特性**进行分析。

- **颗粒感测量**：
    - 在**漫射照明条件**下评估颗粒感。
    - 通过分析表面亮度因子的**空间变化**，专注于**中等空间频率范围**，捕捉颗粒感的视觉纹理。

---

## Aesthetix 提供的闪烁感与颗粒感测量参数

### **闪烁感测量指标**
1. **闪烁密度**：单位面积（100 mm²）内的可见闪烁点数量。
2. **闪烁可见性**：可见闪烁点的平均亮度，相对于背景的对比度。
3. **闪烁面积**：单个闪烁点的平均尺寸（单位：平方微米）。

### **颗粒感测量指标**
1. **颗粒感值（G）**：在漫射照明条件下测量的表面粗糙度，已根据亮度水平进行调整。

---

## **测量参数对比与应用建议**
- **闪烁密度与可见性** → 适用于**高亮度、高光泽度要求的应用**，如**汽车涂层、化妆品表面处理**。
- **颗粒感值** → 适用于**漫射照明下的表面均匀性评估**，如**室内装饰、哑光或纹理涂层**。

在多数应用中，**两者可互补使用**。  
选择测量参数时，应考虑产品的**最终使用环境**是以**定向光照（闪烁感）**还是**漫射光照（颗粒感）**为主。

---

## **在 Appearance Elements 软件中可视化闪烁感和颗粒感**

Rhopoint Appearance Elements 软件提供**详细的闪烁感与颗粒感可视化工具**：

1. **闪烁感可视化**
    - 在 **“闪烁视图”** 选项卡中查看高分辨率的闪烁点图像。
    - **调整阈值** 以突出显示可见闪烁点。
    - 使用**颜色编码叠加**，区分**闪烁密度**和**可见性**。

2. **颗粒感可视化**
    - 切换至 **“颗粒感分布图”**，查看表面亮度变化图。
    - 分析**空间频率数据**，了解颗粒感的分布特性。

3. **交互式工具**
    - 使用**缩放和平移工具**，检查特定区域的细节。
    - **多样本对比**功能，可并排查看多个样本，以评估一致性。

---

## **调整闪烁感与颗粒感**

### **如何调整闪烁感**
1. **增加效果颜料的粒径或浓度**，增强闪烁密度。
2. **优化涂覆方法**（如**喷涂角度、固化条件**），提高闪烁点的均匀性。
3. **使用定向添加剂或特殊效果颜料**，强化特定方向的闪烁效应。

### **如何调整颗粒感**
1. **调整颜料分散性或颗粒大小**，降低颗粒感。
2. **确保涂层厚度均匀**，减少表面纹理不一致性。
3. **采用更精细的抛光或更平滑的基材**，优化整体视觉均匀性。

通过 Aesthetix 的测量，制造商可**优化生产工艺**，以**实现理想的视觉效果**，并确保产品批次间的一致性。
