# 測定結果の解釈 - エフェクト顔料モジュール

## 測定結果の解釈方法

## エステティクスがエフェクト顔料をどのように評価するか

### エフェクト顔料の評価方法

- **きらめき**は、表面に含まれる鏡面要素が方向性のある照明下で周囲より著しく明るく輝く「きらめき点」を解析して評価されます。システムは45°の複数光源と10°の単一光源を用いてハイダイナミックレンジ（HDR）画像を撮影し、これらの光点の視認性、密度、サイズをコントラスト閾値、輝度、空間分布に基づいて算出します。

## スパークルおよび粒状感の測定指標

### スパークル（Sparkle）の指標：

1. **スパークル密度 (Sparkle Density)**：100 mm²あたりの視認可能なきらめき点の数。
2. **スパークルの視認性 (Sparkle Visibility)**：背景に対する視認可能なきらめき点の平均輝度（コントラスト比）。
3. **スパークル面積 (Sparkle Area)**：個々のきらめき点の平均サイズ（平方マイクロメートル）。

### 粒状感メトリクス:

- **粒状感の値 (Graininess Value)**：拡散光条件下での表面の均一性を評価する値で、主に輝度変化の空間的ばらつきから算出されます。

## 用途に応じた指標の選び方

- 自動車塗装や化粧品など、方向性のある照明下での輝き（スパークル）が重要な用途では、「スパークル密度」や「スパークルの視認性」を重視します。
- インテリア仕上げ材やテクスチャーコーティングなど、拡散照明下での表面の均一性が重要な用途では、「粒状感の値 (Graininess Value)」を使用します。

多くの用途において、両方の指標は互いに補完的な情報を提供します。方向性（スパークル）と拡散性（粒状感）のどちらがより重要かによって使い分けます。

## 測定結果の視覚化

### スパークルの視覚化：

1. **スパークル点の視覚化**：
    - 「スパークルポイント画像」ビューで、きらめき点の高解像度画像を表示します。
    - 閾値を調整し、視認可能なきらめき要素を強調します。
    - 色分けされたオーバーレイ表示を使い、きらめき密度と視認性を区別します。

2. **粒状感の視覚化**：
    - 「粒状感マップ」ビューに切り替え、輝度の変動マップを確認します。
    - 空間周波数データを分析します。

## エフェクト顔料の調整方法

### スパークルの調整：
- 塗料に使用する顔料のサイズや濃度を増やしてスパークル密度を向上させます。
- 均一性を改善するために塗布方法（スプレー角度や硬化条件など）を最適化します。
- 指向性添加剤やエフェクト顔料を使って、より顕著なスパークル効果を得ます。

### 粒状感の調整：
- 調合時の顔料分散性や粒径を調整し、粒状感を改善します。
- 塗装方法や硬化条件を最適化して表面の均一性を向上させます。

<note>一般的に、両指標を組み合わせて使用することで、表面外観を包括的に評価し、より効果的な調整が可能になります。</note>
