# Texture Module Overview

The Rhopoint Aesthetix Texture Module provides objective analysis of the surface characteristics critical to visual perception and quality control for textured surfaces.

Textured surfaces are those with irregular or patterned finishes, differing from smooth or flat surfaces. These textures can be natural or manufactured and include features like ridges, grooves, bumps, or grains that affect the material's tactile and visual properties.

Examples include:

1. **Leather-like Surfaces**: Found in automotive interiors and furniture, mimicking natural leather. 
2. **Coated Surfaces**: Textured paint or powder coated surfaces on metal or plastic, influencing appearance and feel.
3. **Plastic pars**: Moulded textures in consumer electronics and automotive components for grip and aesthetics

Textured surfaces are crucial in many industries for their impact on product aesthetics, functionality, and consumer perception, such as automotive, powder coating and leather manufacture, ensuring enhanced quality control, product development, and consistency across global supply chains.

Using Aesthetix, the user can reduce subjective errors associated with visual inspection, ensuring measured surfaces have the required perceived quality and good harmony with adjacent parts.

## Measurement Method

RGB colour, gloss, reflectivity, and 3D topography measurements are combined into a single measurement, delivering precise and repeatable results.
The Aesthetix uses utilizes photometric stereo techniques to estimate surface normals and calculate 3D topography, providing a detailed height map of the surface.

A watershed algorithm is then applied to segment the topography into cells, allowing for the analysis of cell size and area.

60° gloss is measured and reported, fully compliant with international norms ASTM D523 & ISO 2813.

RGB colour is measured using 45°c:0° geometry and the reported values are calculated using the average RGB pixel value of the area captured by the observer camera.

Reflectance parameters are calculated using the gloss camera & reflectance differences measured using the observer camera.

## Texture feature properties (watershed methodology)

### Watershed Overview

To separate features on the surface, a so-called “watershed algorithm” is applied to the topographic height map.

A flooding analogy can be used to understand the watershed principle.
The measured topographical map can be treated like a landscape of hills and valleys.
When water is poured into the landscape, and the water level rises, the valleys (which are the local minima of the gradient image) start filling up with water, separating the hills as islands (“features”).
When water from two different valleys meet and merge, a dam (or watershed line) is constructed to prevent merging.
These watershed lines effectively become the boundaries between different regions in the image.

The result is a segmented image where each region is separated by watershed lines, corresponding to different features within the surface. 
![Topographical height map](watershed-topographical-height-map.jpg)
Topographical height map of surface with watershed analysis applies

Control over how the watershed lines are constructed in Appearance Elements is given in the  “Feature Properties” settings.

## Adjusting the Feature Properties (Watershed parameters)

### Manual Adjustment of the Feature separation

![Feature properties](feature-properties-separation-selection.png)

1. **Visual Inspection**<br />Start by visually inspecting the height image and the initial segmentation results by using the default settings
_(Default: Feature separation: 3px, Feature selection: 70%)_.
![Watershed map with selection](watershed-map-with-selection.jpg)
_In the image above, the default settings have not segmented the whole map successfully- by visual inspection we can see that some features are not separated. In this example features are separated by low areas (valleys) and represent distinct high areas or hill._ 

2. **Adjust Thresholds**<br />
Modify the watershed parameters in “Feature properties” and observe the effect on the feature detection.
Adjust Feature properties and test different values, then evaluate their impact on the segmentation.

### Feature Separation (Watershed Morphology)

This parameter increases the gap between the found features (hills) by the separation value (number of pixels)
Increasing the amount of Pixels used will separate some touching features, and thus increase the number of detected features (hills).
<tip>Note that if the value is too high smaller features (hills) can be completely eroded and will no longer be detected.</tip>

### Feature Selection (Watershed Selection Percentage)

This value from 0% to 100% determines which size of features (hills) are included in the evaluation after separation.
While increasing this number will exclude smaller unwanted features, it should be reduced for smaller shapes.  

In the analysis the watershed algorithm has not separated all the features (hills)- the feature separation parameter “Feature selection” should be increased.

### Watershed parameter adjustment

To adjust the areas selected by the watershed.
- Click the settings button on the right side menu. 
- Click the plus button to expand “Feature properties”.

![Feature properties settings](feature-properties-settings.png)

Adjust “Feature Separation” (watershed morphology) and “Feature Selection” (Watershed Selection Percent) parameters.
- Press "Set" button.
- Press "Recalculate last" button.

Increased Feature Separation value will now correctly analyse the shapes.

| ![Feature separation—before](feature-separation-before.png) | ![Feature separation—after](feature-separation-after.png) |
|-------------------------------------------------------------|-----------------------------------------------------------|
| Before                                                      | After                                                     |

### Invert feature map algorithm

Standard textures and Leather are described by hills which are spatially separated by valleys.
Some technical textures, however, form the actual texture by hills (along their maxima).
For these textures, the standard algorithm will not yield a good or none result, in which case the algorithm has to be “inverted”.
When this happens, please use the “Invert Feature Map” setting, set and recalculate.
Example: the measurement of a technical laser texture does not yield any reasonable results, no matter what is set up in feature selection.

![Invert feature before](invert-feature-before.png)

After selection of “Invert Feature Map” and setting appropriate values, the results become reasonable.
![Invert feature after](invert-feature-after.png)

### Cutting the area of interest
For some applications it might be advisable that the area of interest is cut to a smaller or even larger region than the default (10.00mmx10.00mm), e.g., for steel or metallized surfaces.
This helpful in those cases were there are damages or over illumination due to material albedo at the edges.

In this case, you cut to a more specific region, defining an area by width and height (X and Y) distance, around the centre point of the image (0/0).
For example, Standard setup 10.00mmx10.00mm, from centre point 5.00mm to the left and to the right, as well as 5.00mm up and 5.00mm down.

![texture-preview-1425](texture-preview-1425.png) ![texture-preview-1425-settings](texture-preview-1425-settings.png)

Cut to 10x10, or 5mm in all directions: enter 10mm Width and Height, “Set” and “Recalculate last”.

![texture-preview-1000](texture-preview-1000.png) ![texure-preview-1000-settings](texure-preview-1000-settings.png)

<tip>This has a direct influence on the texture parameters except gloss, so be careful and check your results.</tip>

## Texture Parameters

Each of these indices provided in the Texture Module gives detailed information about the surface's reflectivity characteristics and topographical features, allowing for a comprehensive analysis of its physical and optical properties.

### Gloss 60°
The standard 60° Gloss value, given in GU.

### Roughness "SA Rough" 
Sa Rough is the standard deviation of amplitude for all measured pixels in the field of measurement, unfiltered and raw.
![Heightmap perceived altitude](heightmap-sa-rough.png)

The heightmap shows the perceived altitude of the surface, the profile the perceived altitude over the distance measured.

The controls in the topographic map include:
![Map controls](map-controls.png)
- **Cursor**: this needs to be activated when you want to rotate and pan the topographic view
- **Profile**: activate this feature when you want to measure a profile or a distance in the map
- **ROI cut**: not active yet
- **Plane reference set**: switch between “average” and “zero” plane for profile height reference

![Screenshot watershed](watershed-heightmap-screenshot.png)
The heightmap shows the perceived altitude of the surface. 

### Ca- Cell Amplitude
Ca (reported in [p-µm] (perceived microns)) is defined as the average amplitude of all cells features identified within the texture of a material.

It quantifies the difference between the highest and lowest points, (Average Height of cells- Average Depth of valleys) providing a measure of the vertical dimension of the texture.
This parameter is used to understand the depth and relief of the surface texture, which directly influences visual and tactile perception.
![Watershed cells](watershed-cells.png)

Higher cell amplitude indicates a more pronounced texture, lower values will be measured on smoother materials. 

### Cn- Cell Number
Cn refers to the total number of distinct cells or surface features identified within the field of measurement depending on the watershed parameters set.
This measurement is crucial for understanding the density and distribution of the texture features, which influence visual and tactile qualities.

### Cell Size Indices

Understanding cell size and distribution helps in evaluating the uniformity, coarseness, and overall appearance of the surface, which is essential for quality control and ensuring consistency in product manufacturing.
All Cs indices are reported in [mm²].

### Cs—Mean Cell Size 
Mean Cell Size is the average size of the cells included in the analysis, measured in square millimeters [mm²].
To find this value, the areas of all included cells are measured, and their mean (average) value is calculated. It provides an overall sense of the typical size of the structural features on the surface.

### CsMin—Minimum Cell Size
Cell Size Minimum represents the size of the smallest cell among all those included in the data analysis.
It gives insight into the minimum limit of the structural features present on the surface. 

### CsMax—Maximum Cell Size
Cell Size Maximum is the size of the largest cell among all those included in the data analysis.
It helps in understanding the upper limit of the structural feature sizes present on the surface.

### CsDev—Cell Size Standard Deviation
The Cell Size Standard Deviation reflects the variation in cell sizes across the surface.
By dividing the standard deviation by the mean cell size, the resulting value is normalized, allowing for comparability between different types of structures.
This index indicates how much the sizes of the cells vary from the average, helping to understand the consistency of the surface structure.

### Hs—Hill Size
This is the average cross-sectional area of the hills within the analyzed cells, measured in square millimetres [mm²].
The algorithm detects the cross-sections of the hills and calculates the mean area. The threshold height used to define the cross-sections is parameterized, meaning it can be adjusted based on specific analysis requirements.
Understanding hill size helps in evaluating the distribution and prominence of these elevated features. 

### F—Fill Factor
The Fill Factor index represents the ratio of the mean hill size to the mean cell size, expressed as a percentage. It provides a measure of how much of the cell area is occupied by hills, indicating the density of the elevated structures on the surface or distance between structures. 

## Reflectivity Indices
Reflectivity is an absolute measurement but uses a non-standard unit (arbitrary units [arb'U]) specific to the measurement system.
A higher R value indicates a glossier surface.

### R—Reflectivity
The Mean Reflectivity index R represents the average reflectivity value of the surface, or a value for how the surface interacts with light, contributing to its visual characteristics such as gloss and brightness. 

### RC—Reflective Contrast
This index quantifies the difference in reflectivity between the hills and valleys of the surface topography.
The algorithm separates the surface data into valleys and hills using a parameterized threshold height.
It then calculates the mean reflectivity values for both areas and uses the contrast formula:

<code>contrast = (hill + valley) / (hill − valley)</code>

This provides a measure of how much the reflectivity differs between the elevated and depressed areas of the surface.

### RV—Reflectivity in Valleys
This index represents the average reflectivity value for the areas classified as valleys.
It helps in understanding the reflectivity properties of the lower, depressed regions of the surface.

### RH—Reflectivity on Hills
This is the average reflectivity value specifically for the areas classified as hills.
It provides insight into the reflectivity characteristics of the elevated parts of the surface. 

### Color (RGB)
Average Values of R-G-B pixels in the field of measurement. 

### Unit: Perceived Microns [pµ] 
The unit "perceived" is calculated from Photometric Stereo Topographical maps from the surface slopes and facets that are visible to the camera and calibrated using a 100µ artifact.

Our optical system works best for surfaces with a texture amplitude of 0-1500 (1.5mm) microns with homogeneous reflectivity- in this range the Aesthetix measurement system is linear and obtains results highly correlated to other systems.

<tip>Note that as the texture gets bigger the measurement system becomes less linear-this is because the peaks and valleys of these large structures are less in focus, we also capture shadows in deep valleys that make it difficult to resolve the topography in those areas.</tip>
