# 纹理模块（Texture Module）

Rhopoint Aesthetix 纹理模块提供**客观的表面特征分析**，用于**评估纹理表面对视觉感知和质量控制的影响**。

**纹理表面**不同于光滑或平坦表面，它们具有**不规则或图案化的特征**，可能是**天然形成**或**人工制造**，包括**凸起、凹槽、颗粒或粗糙纹理**，影响材料的触感和视觉特性。

常见应用包括：

1. **仿皮革表面**：用于汽车内饰、家具，模拟天然皮革的质感。
2. **涂层表面**：粉末涂层或涂漆的金属、塑料表面，影响外观和触感。
3. **塑料零件**：消费电子产品、汽车部件上的模压纹理，提高抓握力和美观性。

纹理表面在**汽车、粉末涂层、皮革制造**等行业至关重要，影响**产品外观、功能性和消费者感知**。Aesthetix 通过**减少视觉检查的主观误差**，确保测量表面符合**预期质量**，并与相邻部件保持一致。

---

## **测量方法**

Aesthetix 结合**RGB 颜色、光泽度、反射率和 3D 拓扑测量**，提供**精准、可重复的测量结果**。

- 采用**光度立体（Photometric Stereo）**技术，计算**表面法向量**，生成**三维高度图**。
- 使用**分水岭算法**对拓扑进行分割，分析**单元大小和面积**。
- **60° 光泽测量**符合**ASTM D523 & ISO 2813**国际标准。
- **RGB 颜色测量**使用 **45°c:0°** 几何光照方式，计算测量区域内的**平均 RGB 值**。
- **反射率参数**通过**光泽相机测量**，使用观察相机分析反射率差异。

---

# **纹理特征分析（分水岭方法）**

## **分水岭算法概述**
Aesthetix 采用**分水岭算法**处理**拓扑高度图**，用于分割表面特征。

**分水岭方法的原理**：
- 将表面**高度图**视作**地形图**，将凹陷区域视作**谷地**，凸起部分视作**山丘**。
- 模拟水从低处上升，谷地逐渐填充，当**相邻谷地的水域相遇**，形成**分界线（分水岭）**，防止合并。
- 这些**分水岭线**成为**表面不同特征区域的边界**，从而分割不同纹理单元。

**示例：拓扑高度图分水岭分析**
![拓扑高度图](watershed-topographical-height-map.jpg)

用户可在 **Appearance Elements** 软件的 **“特征属性”** 设置中调整分水岭参数。

---

## **调整特征分离参数（分水岭调整）**

### **手动调整特征分离**
![特征属性](feature-properties-separation-selection.png)

1. **初步检查**
    - 先使用**默认参数**（特征分离：3px，特征选择：70%）。
    - 检查高度图与分割结果是否清晰：
      ![分水岭示例](watershed-map-with-selection.jpg)

2. **调整阈值**
    - 在 **“特征属性”** 设置中**修改分水岭参数**，观察对特征检测的影响。
    - 反复测试不同值，并评估其对分割效果的影响。

### **特征分离（分水岭形态调整）**
- **增加特征分离值** → 增加检测到的特征数量，避免相邻特征合并。
- **过高的数值可能导致小特征消失**，因此应适当调整。

### **特征选择（分水岭选择百分比）**
- 该值范围为 **0% - 100%**，决定**哪些尺寸的特征被纳入分析**。
- **提高该值**可**过滤掉较小的特征**，适用于更大的形态。
- **降低该值**可**检测较小的表面结构**，适用于精细纹理。

### **调整分水岭参数**
- 点击 **设置按钮** → 展开 **“特征属性”** 选项。
- 修改 **“特征分离”** 和 **“特征选择”** 参数。
- 按 **“设置”** → **“重新计算”**。

| ![调整前](feature-separation-before.png) | ![调整后](feature-separation-after.png) |
|---------------------------------------|--------------------------------------|
| 调整前                                   | 调整后                                  |

---

## **反转特征地图（适用于特殊纹理）**
部分**技术纹理**（如激光雕刻表面）特征主要由**凸起（山丘）**而非**凹陷（谷地）**形成。

- **标准分水岭算法**可能无法正确分割这些纹理。
- 在此情况下，需启用 **“反转特征地图”** 功能。
- 选中 **“反转特征地图”**，然后 **重新计算**。

| ![反转前](invert-feature-before.png) | ![反转后](invert-feature-after.png) |
|-----------------------------------|----------------------------------|
| 反转前                               | 反转后                              |

---

# **纹理参数**

Aesthetix 纹理模块提供**多项表面特性参数**，用于**全面分析物理与光学特性**。

### **光泽度（60°）**
- **标准 60° 光泽值**，单位 **GU**。

### **粗糙度（Sa Rough）**
- **未经过滤的表面高度标准差**，用于评估表面微观粗糙度。
  ![高度图示例](heightmap-sa-rough.png)

### **单元特征参数（分水岭分析）**
- **单元幅度（Ca）**：平均特征高度（高点与低点的平均差值）。
- **单元数量（Cn）**：测量区域内的表面特征总数。
- **单元平均大小（Cs）**：特征单元的平均面积（单位：mm²）。
- **单元最小/最大大小（CsMin / CsMax）**：最小和最大表面单元尺寸。
- **单元大小标准差（CsDev）**：单元大小的变化范围。

### **反射率参数**
- **R（平均反射率）**：表面整体反射率水平。
- **RC（反射对比度）**：高点与低点反射率的对比度。
- **RV（谷地反射率）**：表面低洼区域的平均反射率。
- **RH（山丘反射率）**：表面凸起区域的平均反射率。

### **颜色（RGB）**
- 测量区域的 **R-G-B 颜色平均值**，用于颜色均匀性分析。

---

# **测量单位：感知微米 [pµ]**
- **测量单位基于光度立体拓扑计算**，并通过 **100µ 校准标准物**进行标定。
- **适用于 0 - 1500 µm（1.5mm） 纹理**，在此范围内系统线性测量，并与其他测量系统高度相关。

<tip>较大纹理结构可能导致测量系统的非线性性，因为**高度变化较大的结构可能导致相机焦点偏移**，影响深度分辨率。</tip>
