# テクスチャモジュール

Rhopoint Aesthetixテクスチャモジュールは、テクスチャ表面の視覚的特性を客観的に評価し、品質管理をサポートします。

テクスチャ表面とは、不規則またはパターン化された仕上げを持つ表面であり、滑らかまたは平坦な表面とは異なります。これらのテクスチャは自然的または人工的なものであり、隆起、溝、突起、粒子など、材料の触覚および視覚的性質に影響を与える特徴を持ちます。

例：

1. **レザー調表面**：自動車内装や家具などで使用され、本革のような質感を再現します。
2. **コーティング表面**：金属やプラスチックにテクスチャ塗装や粉体塗装を施し、外観や触感に影響を与えます。
3. **プラスチック部品**：家電や自動車部品などに成型されたテクスチャで、グリップ性や外観を向上します。

テクスチャ表面は製品の外観や機能性、消費者の印象に影響するため、自動車産業、粉体塗装、革製品製造など多くの業界で重要視されており、製品開発、品質管理、世界的なサプライチェーンの一貫性確保に役立っています。

Aesthetixを使用することで、視覚的評価に伴う主観的な誤差を削減でき、測定対象の表面が求められる品質と隣接パーツとの調和を確実に満たしていることを確認できます。

## 測定方法

RGBカラー、光沢、反射率、3Dトポグラフィ測定を組み合わせ、正確で再現性の高い測定結果を提供します。  
Aesthetixはフォトメトリックステレオ技術を使用して表面法線を推定し、3Dトポグラフィ（高さマップ）を算出します。

次に、ウォーターシェッド（流域分割）アルゴリズムを適用し、トポグラフィをセルに分割して、セルサイズや面積を解析します。

60°光沢度はASTM D523およびISO 2813に完全準拠して測定されます。

RGB色測定は45°c:0°のジオメトリを用いて行われ、観察用カメラで撮影した領域の平均RGBピクセル値として報告されます。

光沢カメラを使用して反射率パラメータを算出し、観察カメラによる反射率の差異を測定します。

## テクスチャ特性（ウォーターシェッド法）

### ウォーターシェッド概要

ウォーターシェッドアルゴリズムは、表面の特徴を分離するために、トポグラフィの高さマップに適用されます。

この原理は「洪水」を例に説明できます。  
測定された高さマップは丘や谷がある風景として扱われます。  
ここに水を注ぎ水位が上昇すると、谷（局所的な勾配画像の最小値）が水で満たされ、丘が島（特徴）として分離されます。  
異なる谷からの水が合流すると、その合流地点に堰（ウォーターシェッドライン）が構築されます。  
これらのウォーターシェッドラインは画像内の異なる領域を区切る境界線となります。

その結果、ウォーターシェッドラインで区切られた画像が生成され、表面の異なる特徴が示されます。

![Topographical height map](watershed-topographical-height-map.jpg)

Appearance Elementsの「Feature Properties」でウォーターシェッドラインの構築方法を調整できます。

## 特徴プロパティの調整（ウォーターシェッドパラメータ）

### 特徴分離の手動調整

![Feature properties](feature-properties-separation-selection.png)

1. **目視検査**  
   最初にデフォルト設定（Feature separation: 3px、Feature selection: 70%）で高さ画像と初期の分割結果を確認します。

![Watershed map with selection](watershed-map-with-selection.jpg)

上記の画像ではデフォルト設定が全ての特徴を適切に分離していません。この例では谷により特徴が分離され、高さのある丘が明確に認識されます。

2. **閾値調整**  
   「特徴プロパティ」のウォーターシェッドパラメータを調整して特徴検出への影響を確認します。

### 特徴分離 (ウォーターシェッド形態)

このパラメータは特徴（丘）間の間隔をピクセル単位で調整します。  
ピクセル数を増やすと密接した特徴が分離され、検出される特徴数（丘）が増えます。

<tip>値が高すぎると小さな特徴（丘）が消失するため注意してください。</tip>

### 特徴選択（ウォーターシェッド選択率）

0〜100%の間で設定し、分離後に評価対象となる特徴（丘）のサイズを決定します。  
この値を高くすると小さな特徴が除外され、小さな形状を含めるには低く設定します。

### ウォーターシェッドパラメータ調整

ウォーターシェッド領域を調整するには：

- 右側メニューの設定ボタンをクリックします。
- 「特徴プロパティ」をプラスボタンで展開します。

![Feature properties settings](feature-properties-settings.png)

「特徴分離」と「特徴選択」のパラメータを調整します。
- 「Set」ボタンをクリックします。
- 「Recalculate last」ボタンをクリックします。

| ![Feature separation—before](feature-separation-before.png) | ![Feature separation—after](feature-separation-after.png) |
|-------------------------------------------------------------|-----------------------------------------------------------|
| 調整前                                                     | 調整後                                                     |

### 特徴マップ反転アルゴリズム

標準的なテクスチャや革は谷で隔てられた丘で構成されますが、一部の特殊なテクスチャは丘の頂上部で特徴が形成されます。このような場合は「Invert Feature Map」を設定し、再計算します。

![Invert feature before](invert-feature-before.png)  
![Invert feature after](invert-feature-after.png)

### 関心領域の切り出し

用途に応じて、測定領域（デフォルトは10.00mm×10.00mm）は縮小または拡大することができます（例：鋼板や金属蒸着表面など）。

画像中心からX・Y方向の距離を指定し、特定領域を切り出します。

![texture-preview-1425](texture-preview-1425.png)  
![texture-preview-1425-settings](texture-preview-1425-settings.png)

10mm×10mmに切り出す場合、幅と高さを10mmに設定し、「Set」と「Recalculate last」を押します。

![texture-preview-1000](texture-preview-1000.png)  
![texture-preview-1000-settings](texure-preview-1000-settings.png)

<tip>光沢以外のテクスチャパラメータに直接影響しますので、慎重に確認してください。</tip>

## テクスチャパラメータ

テクスチャモジュールで提供される各指標は、表面の反射特性と地形的特徴に関する詳細な情報を提供し、物理的および光学的特性の包括的な分析を可能にします。

### グロス60°
標準的な60°グロス値（単位：GU）です。

### 粗さ "SA Rough"
Sa Roughは、測定フィールド内の全ピクセルについて、生の未フィルター状態での振幅の標準偏差です。
![高さマップ 知覚高度](heightmap-sa-rough.png)

高さマップは表面の知覚高度を示しており、プロファイルは測定された距離にわたる知覚高度を示します。

地形マップのコントロールには以下が含まれます:
![マップのコントロール](map-controls.png)
- **カーソル**: 地形ビューを回転・移動する際に有効にします。
- **プロファイル**: マップ上でプロファイルまたは距離を測定する際に有効にします。
- **ROIカット**: 現在は非アクティブです。
- **基準面設定**: プロファイル高さの基準を「平均」または「ゼロ」面の間で切り替えます。

![ウォーターシェッドスクリーンショット](watershed-heightmap-screenshot.png)
高さマップは表面の知覚高度を示します。

### Ca - セル振幅
Ca（単位：[p-µm]（知覚マイクロメートル））は、素材テクスチャ内で特定されたすべてのセルの平均振幅として定義されます。

これは最も高い地点と低い地点の差（セルの平均高さ－谷の平均深さ）を定量化し、テクスチャの垂直方向の寸法を測定します。このパラメータは、視覚的および触覚的な認識に直接影響を与える表面テクスチャの深さや起伏を理解するために使用されます。
![ウォーターシェッドセル](watershed-cells.png)

セルの振幅が大きいほどテクスチャは顕著になり、小さいほど表面が滑らかになります。

### Cn - セル数
Cnは、ウォーターシェッドパラメータに基づいて測定フィールド内で識別されたセルまたは表面特徴の総数を示します。この測定はテクスチャの密度や分布を理解する上で重要であり、視覚的および触覚的特性に影響します。

### セルサイズ指標
セルサイズとその分布を理解することは、表面の均一性、粗さ、全体的な外観を評価するのに役立ち、品質管理や製品製造における一貫性確保に不可欠です。
すべてのCs指標の単位は[mm²]です。

### Cs—セルサイズ平均
セルサイズ平均は、分析に含まれるセルの平均サイズを平方ミリメートル[mm²]で示したものです。この値を求めるには、含まれるすべてのセルの面積を測定し、その平均を計算します。これにより、表面構造の典型的なサイズ感を把握できます。

### CsMin—最小セルサイズ
セルサイズ最小値は、分析データに含まれる全セルの中で最も小さいセルのサイズです。これは表面に存在する構造的特徴の最小限を示します。

### CsMax—最大セルサイズ
セルサイズ最大値は、分析データに含まれる全セルの中で最も大きいセルのサイズです。これは表面構造の特徴のサイズの上限を理解するのに役立ちます。

### CsDev—セルサイズ標準偏差
セルサイズ標準偏差は、表面全体にわたるセルサイズのばらつきを示します。標準偏差を平均セルサイズで割ることで正規化され、異なるタイプの構造間での比較を可能にします。この指標はセルサイズが平均からどれほどばらついているかを示し、表面構造の一貫性を把握するのに役立ちます。

### Hs—丘のサイズ
これは分析されたセル内の丘の平均断面積を平方ミリメートル[mm²]で示したものです。アルゴリズムは丘の断面を検出し、その平均面積を計算します。断面を定義するための閾値の高さはパラメータ化されており、特定の分析要件に応じて調整可能です。丘のサイズを理解することで、隆起した特徴の分布や顕著さを評価できます。

### F—充填率
充填率は、平均丘サイズと平均セルサイズの比率をパーセンテージで示します。これはセル面積のどの程度が丘によって占められているかを示し、表面の隆起構造の密度または構造間の距離を表します。

## 反射率指標
反射率は絶対的な測定ですが、測定システム固有の非標準単位（任意単位 [arb'U]）を使用します。R値が高いほど表面は光沢が強くなります。

### R—反射率
平均反射率Rは表面の平均的な反射率を示し、表面がどのように光と相互作用するかを表します。これは光沢や明るさなどの視覚特性に影響します。

### RC—反射コントラスト
反射率のコントラストは表面の丘と谷の反射率の差を示します。アルゴリズムは閾値の高さを用いて表面データを谷と丘に分割し、それぞれの平均反射率を算出します。次のコントラスト式で計算されます：

<code>contrast = (hill + valley) / (hill − valley)</code>

### RV—丘の反射率
丘と分類された領域の平均反射率を示します。

### RH—谷の反射率
谷と分類された領域の平均反射率です。

### 色（RGB）
測定フィールド内のR-G-Bピクセルの平均値。

### 単位: 視覚マイクロメートル[pµm]

本システムは均一な反射率で、構造が大きすぎない場合に高精度な結果を得られます。

<tip>構造が大きくなるほど測定システムの直線性が低下します。これは大きな構造のピークや谷が焦点外になりやすく、深い谷に影が生じるためです。</tip>
