# Surface Brilliance Module
The Surfaces Brilliance Module quantifies all of the aspects of a glossy surface which contribute to the perception of appearance quality. 

### Measuring Glossiness Perception
Describing the perceived surface quality of high gloss surfaces requires a multi-faceted approach that includes gloss, contrast gloss, haze, sharpness, and waviness measurements. Each parameter provides unique insights into the surface's reflective properties, contributing to a comprehensive understanding of its aesthetic and functional qualities.

### Gloss
Definition: Gloss refers to the overall shiny appearance of a surface when light is reflected directly off it. It is often measured using glossmeters which quantify the amount of reflected light at specific angles.

Importance: Gloss is the most widely used measure of a surface's ability to reflect light in a specular manner, contributing to its shiny appearance.

[Continue reading](Standard-Gloss-Measurement.md)

### Visual Gloss
Definition: Also known as contrast gloss it is a measure of the perceived gloss the specular and diffusely reflecting areas on a surface.

Importance: This measure is crucial for distinguishing between high gloss surfaces that may have similar specular gloss but differ in their overall perceived shininess due to texture or material properties (Ignell et al., 2010).

[Continue reading](Visual-Gloss.md)


### Haze
Definition: Haze refers to the light scattering that causes a milky or cloudy appearance around specular reflections. It is often the result of surface imperfections or coatings that scatter light.

Importance: High haze reduces the perceived clarity and glossiness of a surface (Vangorp et al., 2017). 

[Continue reading](Haze.md)

### Sharpness
Definition: Sharpness, also referred to as distinctness of image (DOI), measures the clarity and detail of reflections seen on a surface. High DOI indicates clear, sharp reflections.

Importance: DOI is critical for surfaces where the quality of reflected images is essential, such as in automotive finishes and photographic papers. It correlates strongly with customer perception of quality (Tse et al., 2005). 

[Continue reading](Sharpness-DOI.md)

### Waviness
Definition: Waviness refers to the surface texture's longer wavelength deviations. It is a measure of surface smoothness and orange peel effects.

Importance: Surface waviness can significantly affect the overall appearance of gloss. Smooth surfaces with minimal waviness have better visual appeal.

## Comprehensive Glossiness Perception

### Combining Measurements
By integrating measurements of gloss, contrast gloss, haze, sharpness, and waviness, a more comprehensive understanding of surface glossiness can be achieved. Each measurement addresses a different aspect of the reflective quality and texture of the surface. 

### Interdependencies
Contrast gloss and haze often interact, where surfaces with high contrast gloss may exhibit lower haze, leading to clearer reflections.

Sharpness (DOI) and waviness are related; surfaces with low waviness typically have higher DOI due to the reduced scattering of light.

