# 表面光泽度模块（Surface Brilliance Module）

**表面光泽度模块**量化了**所有影响光亮表面外观质量**的因素。

### 评估光泽感知（Measuring Glossiness Perception）

要描述**高光泽表面的感知质量**，需要采用多维度的方法，包括测量**光泽度、对比光泽、雾影（Haze）、清晰度（Sharpness）和波纹度（Waviness）**。  
每个参数都能提供关于表面反射特性的独特见解，从而帮助全面理解其美学和功能特性。

### 光泽度（Gloss）

**定义**：光泽度指的是当光线直接反射到表面时，表面的整体光亮程度。通常使用**光泽度计**（Glossmeter）来测量，在特定角度下量化反射光的强度。

**重要性**：光泽度是衡量表面**镜面反射能力**的最常见指标，决定了其光亮程度。

[继续阅读](Standard-Gloss-Measurement-zh.md)

### 视觉光泽（Visual Gloss）

**定义**：也称为**对比光泽（Contrast Gloss）**，用于评估表面**镜面反射区域和漫反射区域**的感知光泽度。

**重要性**：这一测量对于区分高光泽表面至关重要，尤其是那些**镜面光泽相似但由于纹理或材料特性不同而表现出不同感知光亮度**的表面。（Ignell et al., 2010）

[继续阅读](Visual-Gloss-zh.md)

### 雾影（Haze）

**定义**：雾影指的是由于**光散射**而导致的**镜面反射区域周围出现乳白色或朦胧效果**。通常由表面缺陷或涂层引起。

**重要性**：**高雾影会降低表面的清晰度和光泽感**。（Vangorp et al., 2017）

[继续阅读](Haze-zh.md)

### 清晰度（Sharpness）

**定义**：清晰度（也称**影像清晰度（DOI）**）测量表面反射的清晰度和细节程度。高 DOI 表示**反射图像更清晰锐利**。

**重要性**：DOI 对于需要**高质量反射图像**的表面（如汽车涂层和摄影纸）至关重要，并且**与客户对质量的感知强烈相关**。（Tse et al., 2005）

[继续阅读](Sharpness-DOI-zh.md)

### 波纹度（Waviness）

**定义**：波纹度指的是表面**较长波长的纹理起伏**，可用于评估**表面平滑度**及**橘皮效应**。

**重要性**：波纹度显著影响光泽的整体视觉效果。**较少波纹度的光滑表面视觉吸引力更高**。

## 综合光泽感知（Comprehensive Glossiness Perception）

### 组合测量（Combining Measurements）

通过整合**光泽度、对比光泽、雾影、清晰度和波纹度**的测量数据，可以**更全面地理解表面光泽的表现**。  
每个测量参数都侧重于表面反射质量和纹理的不同方面。

### 相互影响（Interdependencies）

- **对比光泽（Contrast Gloss）和雾影（Haze）**通常相互影响——**对比光泽较高的表面通常雾影较低**，从而产生更清晰的反射。
- **清晰度（DOI）和波纹度（Waviness）**密切相关——波纹度较低的表面通常**具有更高的 DOI**，因为光散射较少，反射更加清晰。
