# 表面ブリリアンスモジュール

表面ブリリアンスモジュールは、光沢表面の外観品質の知覚に寄与するすべての要素を定量化します。

### 光沢感の測定
高光沢表面の品質を記述するには、光沢、コントラスト光沢、ヘイズ、シャープネス、ウェービネス（ゆず肌）の測定を含む多面的なアプローチが必要です。各パラメータは表面の反射特性について独自の洞察を提供し、その美的および機能的な特性を包括的に理解するために寄与します。

### 光沢 (Gloss)
**定義:**  
光沢とは、光が直接反射したときに表面が持つ全体的な輝きの外観を指します。通常、特定の角度で反射された光量を定量化するためにグロスメーターを使用して測定されます。

**重要性:**  
光沢は、表面が鏡面反射を行う能力を最も広く使用される指標であり、その輝き外観に寄与します。

[詳細はこちら](Standard-Gloss-Measurement-ja.md)

### 視覚的光沢 (Visual Gloss)
**定義:**  
コントラスト光沢とも呼ばれ、表面上の鏡面反射領域と拡散反射領域の明るさの差を測定します。

**重要性:**  
視覚的光沢は、同様の鏡面光沢を持つ高光沢表面間であっても、テクスチャや材料特性による全体的な輝き感の違いを区別するために重要です (Ignell et al., 2010)。

[詳細はこちら](Visual-Gloss-ja.md)

### ヘイズ (Haze)
**定義:**  
ヘイズとは、鏡面反射周辺に乳白色または曇った外観を引き起こす光散乱を指します。これは通常、表面の欠陥やコーティングによるものです。

**重要性:**  
高いヘイズは表面の明瞭さと光沢感を低下させます (Vangorp et al., 2017)。

[詳細はこちら](Haze-ja.md)

### シャープネス (Sharpness)
**定義:**  
シャープネス（鮮映度: DOI）は、表面上で見られる反射像の明瞭さと詳細度を測定します。高いDOIは鮮明でシャープな反射を示します。

**重要性:**  
DOIは、自動車仕上げや写真用紙など、反射画像の品質が重要な表面において非常に重要です。また、顧客の品質認識と強く相関しています (Tse et al., 2005)。

[詳細はこちら](Sharpness-DOI-ja.md)

### ウェービネス (Waviness)
**定義:**  
ウェービネスは、表面テクスチャの長波長偏差を指し、表面の滑らかさやオレンジピール効果を測定します。

**重要性:**  
ウェービネスが少ない滑らかな表面は視覚的魅力が高くなります。

## 包括的な光沢感評価

### 測定値の統合
光沢、コントラスト光沢、ヘイズ、シャープネス、およびウェービネスの測定値を統合することで、表面光沢感についてより包括的な理解が得られます。各測定値は、表面の反射品質とテクスチャの異なる側面に対応しています。

### 相互依存性
- コントラスト光沢とヘイズはしばしば相互作用し、高いコントラスト光沢を持つ表面ではヘイズが低くなる傾向があり、より明瞭な反射が得られます。
- シャープネス（DOI）とウェービネスも関連しており、ウェービネスが少ない表面では通常、高いDOIが得られるため、光散乱が減少します。
