# Gloss
60° Gloss is the universal gloss measurement parameter used in most industries.

## Standard Gloss Overview
Gloss is a measure of how well a surface reflects light in a specular (mirror-like) direction.  
In industry, gloss is crucial for assessing the aesthetic and functional qualities of products.

A High gloss finish is often desired for its visual appeal, giving surfaces a shiny, sleek, and premium look, commonly seen in automotive finishes, consumer electronics, and high-end furniture.

Low gloss or matte finishes are used to reduce glare and provide a softer, more subtle appearance, which is preferred in certain architectural coatings and household appliances.

Gloss measurement helps ensure consistency and quality control in manufacturing processes, influencing customer satisfaction and product performance.

## Gloss GU (Standard Gloss)
The Aesthetix measures the amount of light reflected from a material in a specific, controlled manner according to ISO 2813 and ASTM D523 international standards.

The Aesthetix measures gloss using the "universal" measurement geometry of 60 degrees, the most widely used measurement for understanding glossiness of a material.

## Gloss Measurement with Rhopoint Aesthetix
Why Use the Rhopoint Aesthetix for High-Gloss Surfaces?

Experience teaches us that simple gloss measurement is not sufficient to measure the surface quality of high-gloss products because common imperfections like haziness and orange peel reduce percieved quality but are not measured by a simple glossmeter.

The Rhopoint Aesthetix Gloss Module accurately measures gloss, haze, distinctness of image (DOI), and visual gloss to ensure surfaces look perfect and uniform.

This is important in industries like automotive, electronics, and luxury products, where surface quality affects product value and customer appeal.

## Gloss Calibration
Aesthetix instruments are supplied with a ISO 17025 high gloss calibration tile in accordance with the relevant standards.

## Measurement of Gloss
![Gloss Window—measurement of a glass standard](gloss-window-glass-standard.png)
<sup>Gloss Window—measurement of a glass standard</sup><br />

Aesthetix measures by projecting a rectangular image on to the sample surface which is reflected onto an internal camera sensor.
The camera sensor measures the amount of light reflected in the Gloss ROI shown in yellow in the figure.

## Surface Characteristics that determine Gloss
Surface texture present on a surface material (roughness, micro roughness, and nano texture) will reflect a mixture of specular and scattered (diffuse) light.

The refractive index of a coating determines the proportion of  light that is reflected from the surface (gloss) compared to the amount absorbed within the basecoat or substrate.

Metallic and special effect coatings contain mirror like facets of mica or metal flake will demonstrate increased gloss due to light reflected within the from these elements.

Highly background colours- for example white & yellow exhibit a slightly higher gloss level than absorbent colours black, dark grey, etc.

For multilayer transparent materials, gloss values can be increased due to multiple reflections within the material.

## Where is gloss used?
- **Quality Control in Manufacturing**: To ensure consistency and quality of products, gloss measurements can be taken at various stages of production.
- **Surface Treatment and Finishing of low to mid gloss material**: After processes like painting, varnishing, to verify that the desired level of gloss has been achieved.
- **Comparative Analysis of materials with the same background colour**: When comparing different batches of materials or products to ensure uniform appearance.
- **Surface Damage Assessment**: To assess wear, fading, or other surface changes over time.
