# 光泽度（Gloss）

**60° 光泽度**是**各行业通用的光泽测量参数**。

## 标准光泽概述（Standard Gloss Overview）

光泽度衡量的是**表面以镜面（Specular）方式反射光线的能力**。  
在工业领域，光泽度是评估产品**美观性和功能特性**的重要指标。

- **高光泽**（High Gloss）表面因其**光亮、平滑和高端**的视觉效果而备受青睐，常见于**汽车涂层、消费电子产品和高端家具**。
- **低光泽或哑光**（Matte）涂层可**减少眩光**，提供更柔和、低调的外观，广泛应用于**建筑涂料和家用电器**。

光泽测量在**制造过程中**确保产品的一致性和质量控制，对**客户满意度和产品性能**具有重要影响。

---

## 光泽度单位（GU）（Standard Gloss）

Aesthetix 依据**ISO 2813 和 ASTM D523 国际标准**，**精确测量材料在特定受控条件下的反射光量**。

Aesthetix 采用**60° 测量角度**进行光泽测量，这是**行业内最广泛使用的光泽测量角度**，适用于大多数材料的光泽度评估。

---

## 使用 Rhopoint Aesthetix 进行光泽测量

### 为什么选择 Aesthetix 进行高光泽表面测量？

经验表明，**单一光泽度测量**无法全面评估**高光泽产品的表面质量**，因为**常见缺陷**（如**雾影（Haze）和橘皮效应（Orange Peel）**）会降低产品的感知质量，但**传统光泽计无法检测**这些问题。

Rhopoint Aesthetix **光泽度模块**可同时测量：
- **光泽度（Gloss）**
- **雾影（Haze）**
- **影像清晰度（DOI）**
- **视觉光泽（Visual Gloss）**

这些参数确保了表面光泽的**完美性和均匀性**，这对于**汽车、电子产品和奢侈品行业**至关重要，因为**表面质量直接影响产品价值和客户吸引力**。

---

## 光泽校准（Gloss Calibration）

Aesthetix 仪器配备符合**ISO 17025 标准**的**高光泽度校准标准板**，确保测量结果符合相关标准要求。

---

## 光泽测量方法（Measurement of Gloss）

![玻璃标准的光泽测量界面](gloss-window-glass-standard.png)
<sup>光泽测量界面 - 玻璃标准样品</sup><br />

Aesthetix 通过**向样品表面投射矩形光束**，然后**测量光线在表面反射后投射到内部摄像传感器上的强度**。  
摄像传感器会测量光泽测量区域（**Gloss ROI**，图中黄色区域）的反射光量。

---

## 影响光泽度的表面特性（Surface Characteristics that Determine Gloss）

**影响光泽度的主要因素**包括：

- **表面纹理（Surface Texture）**：  
  表面的**粗糙度（Roughness）、微观粗糙度（Micro-Roughness）和纳米纹理（Nano-Texture）**会导致**镜面反射和漫反射（Diffuse Reflection）光的混合**，影响光泽测量值。

- **涂层的折射率（Refractive Index）**：  
  **涂层的折射率决定了光的反射比例**，即有多少光被反射，而多少光被涂层或底材吸收。

- **金属和特效涂层（Metallic and Special Effect Coatings）**：  
  含有**云母或金属颗粒**的涂层会增加光的反射，从而提升光泽度。

- **背景颜色（Background Color）**：  
  **浅色（如白色、黄色）通常表现出比深色（如黑色、深灰色）稍高的光泽值**，因为深色材料会吸收更多光线。

- **多层透明材料（Multilayer Transparent Materials）**：  
  由于**光在材料内部发生多次反射**，透明材料的光泽度通常较高。

---

## 光泽测量的应用领域（Where is Gloss Used?）

- **制造过程中的质量控制（Quality Control in Manufacturing）**
    - 在生产过程的不同阶段进行光泽测量，以确保产品的一致性和质量。

- **低至中光泽材料的表面处理和精加工（Surface Treatment and Finishing）**
    - 例如**喷涂、清漆**等工艺后，检测是否达到所需的光泽水平。

- **相同背景色材料的比较分析（Comparative Analysis of Materials with the Same Background Color）**
    - 比较不同批次的材料或产品，以确保**外观的一致性**。

- **表面损伤评估（Surface Damage Assessment）**
    - 用于评估表面的**磨损、褪色或其他长期变化**。
