# Gloss

## 60°光沢
60°光沢は、ほとんどの業界で使用される普遍的な光沢測定パラメータです。

### 標準光沢の概要
**光沢**は、表面が鏡面方向にどれだけうまく光を反射するかを測定するものです。  
業界では、製品の美的および機能的品質を評価する際に光沢が重要視されます。

- **高光沢仕上げ**: 自動車の塗装、消費者向け電子機器、高級家具などで見られるように、表面に輝きや滑らかさ、高級感を与える視覚的な魅力が求められます。
- **低光沢またはマット仕上げ**: 眩しさを軽減し、柔らかく控えめな外観を提供します。建築用コーティングや家庭用電化製品などで好まれます。

光沢測定は、製造プロセスにおける一貫性と品質管理を保証し、顧客満足度と製品性能に影響を与えます。

---

## 光沢 GU (標準光沢)
Rhopoint Aesthetixは、ISO 2813およびASTM D523国際規格に従って、特定の制御された方法で材料から反射される光の量を測定します。

Aesthetixは「普遍的」な60°測定ジオメトリを使用して光沢を測定します。この角度は、材料の光沢性を理解するために最も広く使用されています。

---

## Rhopoint Aesthetixによる光沢測定
なぜ高光沢表面にRhopoint Aesthetixを使用するのか？
経験から、単純な光沢測定では高光沢製品の表面品質を十分に評価できないことが分かっています。曇りやゆず肌などの一般的な欠陥は、知覚される品質を低下させますが、従来のグロスメーターではこれらを検出できません。

Rhopoint Aesthetix Gloss Moduleは、以下の項目を正確に測定します:
- 光沢
- ヘイズ
- 鮮映度 (DOI)
- 視覚的光沢

これにより、表面が完璧で均一に見えることを保証します。この機能は、自動車業界、電子機器、高級製品などで重要です。これらの業界では表面品質が製品価値と顧客への訴求力に影響します。

---

## 光沢校正
Aesthetix機器にはISO 17025高光沢校正タイルが付属しており、関連する規格に準拠しています。

---

## 光沢の測定方法
![Glass標準の測定ウィンドウ](gloss-window-glass-standard.png)
<sup>Glass標準の測定ウィンドウ</sup>

Aesthetixは矩形画像をサンプル表面に投影し、それが内部カメラセンサーに反射されることで測定します。  
カメラセンサーは図中黄色で示されたGloss ROI内で反射された光量を測定します。

---

## 光沢を決定する表面特性
1. **表面テクスチャ**: 表面粗さ、微細粗さ、およびナノテクスチャは、鏡面反射と散乱（拡散）反射の混合物として光を反射します。
2. **屈折率**: コーティングの屈折率は、ベースコートまたは基材内で吸収される量と比較して表面から反射される光（光沢）の割合を決定します。
3. **金属および特殊効果コーティング**: マイカや金属フレークなど鏡面状の要素が含まれるコーティングは、それらによって反射される光によって光沢が増加します。
4. **背景色**: 白や黄色など明るい背景色は黒や濃い灰色など吸収性の高い色よりもわずかに高い光沢レベルを示します。
5. **多層透明材料**: 材料内で複数回反射することで光沢値が増加する場合があります。

---

## 光沢が使用される場面
- **製造業での品質管理**: 一貫性と製品品質を確保するため、生産段階で様々な箇所で光沢測定が行われます。
- **低〜中程度の光沢材料の表面処理と仕上げ**: 塗装やワニス処理後に望ましいレベルの光沢が達成されたことを確認します。
- **同じ背景色を持つ材料の比較分析**: 材料や製品の異なるバッチ間で均一な外観を確保するため。
- **表面損傷評価**: 時間経過による摩耗、退色、その他の表面変化を評価します。
