# シャープネス (Sharpness)

## **シャープネスとは何か？**

シャープネスは、表面がシャープで明瞭な反射を生成する能力を定量化するための新しい測定基準です。  
これはDOI（鮮映度）に密接に関連していますが、特に反射内のエッジのシャープさと明瞭さに焦点を当てています。

- **高いシャープネス/DOI**: 高光沢表面では、滑らかで鏡のような反射面を示し、高品質と認識されます。
- **低いシャープネス**: ぼやけた、不明瞭な表面を示し、仕上げの深みが欠け、消費者に「品質感」の低下を与えます。

---

## **重要性**

- **高いシャープネスの必要性**: 自動車塗装、消費者向け電子機器、磨かれた石材、反射金属部品、高級家具などの製品では、視覚的な魅力を維持するために不可欠です。
- **人間の知覚との相関**: Rhopoint Aesthetixによる新しいシャープネス測定は、多数の観察者による知覚研究を基に開発されており、その結果は視覚的知覚と高い相関があります。

---

## **Rhopoint Aesthetixによるシャープネス測定**

Rhopoint Aesthetixは、サンプル表面に反射した光源のカメラ画像からシャープネスを導出します。この測定はDOIよりも感度が高く、人間の知覚とより良く一致します。

---

## **シャープネススケール**

| シャープネス値 (SU) | 説明                                                                 |
|---------------------|----------------------------------------------------------------------|
| 0-20               | 非常に低いシャープネス - ぼやけた反射でエッジが不明瞭。               |
| 21-40              | 低いシャープネス - 反射画像はややぼやけているがエッジは識別可能。     |
| 41-60              | 中程度のシャープネス - エッジがより明瞭で、反射画像がはっきりしている。 |
| 61-80              | 高いシャープネス - 非常に明確で鮮明なエッジを持つ反射画像。           |
| 81-100             | 非常に高いシャープネス - 極めてクリアでエッジが鋭く定義されている。   |

---

## **DOIとの関係**

DOIとシャープネスはどちらも反射画像の明瞭さを測定しますが、それぞれ異なる側面に焦点を当てています:
- **DOI**: 全体的な反射画像の明瞭さと鮮映度を評価します。
- **シャープネス**: 特に反射画像内のエッジの明瞭さと定義性を評価します。

---

## **シャープネスの低下原因**

1. 表面テクスチャ: 一定サイズ以上の表面テクスチャがあるとシャープネスが低下します。
2. ヘイズ (Log Haze C): 光散乱によるコントラスト低下が原因となります。

---

## **製品改善への応用**

1. **美観向上**: シャープネスを改善することで製品の視覚的魅力（Kerb Appeal）を向上させます。
2. **製造プロセス最適化**: シャープネスの客観的測定は、製造プロセスや材料選択の最適化に役立ちます。
3. **視覚的調和**: 製品全体で一貫した外観品質を確保するため、複数部品間で一致したシャープネス仕様を設定します。

<tip>視覚的調和を確保するには、すべての部品に達成可能な公差付き仕様（例: 85 SU ± 5 SU）を設定してください。</tip>
