# シャープネスの解釈

## **シャープネススケール**

| シャープネス単位 (SU) | 説明                                  |
|---------------|-------------------------------------|
| 0-20 SU       | 非常に低いシャープネス—ぼやけた反射でエッジが不明瞭。         |
| 21-40 SU      | 低いシャープネス—反射画像はややぼやけているが、エッジは識別可能。   |
| 41-60 SU      | 中程度のシャープネス—エッジがより明瞭で、反射画像がはっきりしている。 |
| 61-80 SU      | 高いシャープネス—非常に明確で鮮明なエッジを持つ反射画像。       |
| 81-100 SU     | 非常に高いシャープネス—極めてクリアでエッジが鋭く定義されている。   |

---

## **DOIとシャープネスの関係**

DOIとシャープネスはどちらも反射画像の明瞭さを測定しますが、それぞれ異なる側面に焦点を当てています:
- **DOI**: 全体的な反射画像の明瞭さと鮮映度を評価します。
- **シャープネス**: 特に反射画像内のエッジの明瞭さと定義性を評価します。

<note>シャープネスはDOIよりも感度が高く、人間の知覚とより良く一致するため、特に高品質な表面の評価に適しています。</note>
