# Sharpness and DOI Interpretation

| DOI Units | Description                                                  |
|-----------|--------------------------------------------------------------|
| 0-50 %    | No discernible reflected image.                              |
| 50-70 %   | Low DOI, a reflected image is barely visible.                |
| 70-90 %   | Moderate DOI,  a distinct reflected image is visible.        |
| 90-95 %   | High DOI, showing a very clear and distinct reflected image. |
| 95-100 %  | Very high DOI, indicating an exceptionally clear reflection. |



# What are sharpness and DOI?

How does Aesthetix these values?
How do these values compare, which one should i use for my application?
How Can I visualise DOI/Sharpness Using Appearance Elements?
How can I change the DOI and Sharpness of a surface?

## Sharpness and DOI

Sharpness and Distinctness of Image (DOI) are related measurements that quantify the clarity and definition of reflections on a surface.

### Sharpness

Sharpness specifically assesses the clarity and definition of edges within a reflected image. It is measured on a scale from 0 to 100 Sharpness Units (SU), where higher values indicate clearer, sharper reflections[^1].

### Distinctness of Image (DOI)

DOI evaluates the overall clarity and distinctness of the entire reflected image. It quantifies how clearly and undistorted an image is reflected off a surface[^1].

## Aesthetix Measurement Method

The Aesthetix measures sharpness by:

1. Capturing a high-resolution image of a light source reflected on the sample surface using its camera sensor
2. Analyzing the sharpness of edges in this reflected image
3. Deriving a sharpness value that correlates with human visual perception[^1]

For DOI, the Aesthetix likely uses a similar image-based approach, analyzing the overall clarity of the reflected image rather than focusing specifically on edge sharpness.

## Comparison and Usage

Sharpness is generally considered more advanced and sensitive than traditional DOI measurements, especially for high-quality surfaces[^1].

- Sharpness provides more detailed information about edge clarity in reflections
- Sharpness correlates better with human visual perception
- Sharpness can detect subtle differences in very high-quality surfaces that DOI may miss

For most modern applications, especially those involving high-gloss or high-quality surfaces, sharpness is recommended over DOI. However, DOI may still be used for backwards compatibility with existing specifications or standards[^1].

## Visualizing in Appearance Elements

To visualize sharpness/DOI in Appearance Elements:

1. Use the live view feature from the gloss camera
2. Switch to the gloss camera view using the switch camera icon
3. Use auto-exposure to optimize for the surface's reflectivity
4. Manually adjust exposure if needed
5. Control the specular light source, line light, and spotlight as needed[^2]

The software will display sharpness/DOI values and may provide visual representations of the reflected image quality.

## Changing DOI and Sharpness

To improve DOI and sharpness of a surface:

1. Enhance surface smoothness through finer polishing or sanding techniques
2. Optimize coating formulations to promote better leveling and flow
3. Improve application methods to minimize orange peel and other texture issues
4. Ensure proper curing conditions to allow coatings to level optimally
5. Use high-quality basecoats or primers to create a smoother foundation
6. For plastic parts, optimize molding conditions to reduce surface defects
7. Consider using flow additives in coatings to promote better leveling

Remember that changes to improve sharpness/DOI may affect other surface properties, so consider the overall impact on the product's appearance and performance[^1].
