# 清晰度与影像清晰度（DOI）解析

## **DOI 数值及其含义**

| DOI (%)  | 反射图像描述                                            |
|----------|--------------------------------------------------------|
| 0-50     | 无可辨别的反射图像。                                    |
| 50-70    | 低 DOI，反射图像勉强可见，边缘模糊。                    |
| 70-90    | 中等 DOI，反射图像明显可见，清晰度适中。                |
| 90-95    | 高 DOI，反射图像清晰，边缘锐利。                        |
| 95-100   | 极高 DOI，反射图像极其清晰，边缘锐利且无失真。          |

---

# **什么是清晰度（Sharpness）和影像清晰度（DOI）？**

- Aesthetix 如何测量这些数值？
- 这些数值如何比较，如何选择适合的测量方法？
- 如何在 **Appearance Elements** 中可视化 **DOI/清晰度**？
- 如何优化表面的 **DOI 和清晰度**？

---

## **清晰度与影像清晰度**

清晰度（Sharpness）和影像清晰度（DOI）都是**用于评估表面反射质量的指标**，但它们的测量重点有所不同。

### **清晰度**
- 评估**反射图像中边缘的锐利度和清晰度**。
- 采用 **0-100 清晰度单位（SU）** 进行测量，数值越高，反射图像越清晰锐利。

### **影像清晰度**
- 评估**整个反射图像的整体清晰度和失真程度**。
- 数值越高，表面对图像的反射越清晰，越接近完美镜面反射。

---

## **Aesthetix 测量方法**

### **清晰度（Sharpness）测量**
1. 通过 Aesthetix 传感器**捕捉光源在样品表面的高分辨率反射图像**。
2. **分析反射图像的边缘锐利度**，计算清晰度值。
3. **清晰度测量结果高度匹配人眼视觉感知**。

### **影像清晰度测量**
- 采用类似的**图像分析方法**，但重点在**整体反射图像的清晰度**，而非边缘锐利度。

---

## **清晰度 vs. DOI：如何选择适合的测量方法？**

- **清晰度测量比传统 DOI 更高级、更敏感**，特别适用于**高质量表面评估**。
- **清晰度测量的优势**：
    - 提供更详细的**反射图像边缘清晰度信息**。
    - 更符合**人眼感知**，特别适用于**超光滑表面的微小变化检测**。
    - 能检测到 **DOI 可能遗漏的高品质表面微观差异**。

### **选择推荐**
- **对于高光泽、高质量表面（如汽车涂层、电子产品、金属饰面），推荐使用清晰度测量。**
- **DOI 仍可用于符合既有规格或标准的场景，例如与历史测量数据保持一致的质量控制。**

---

## **在 Appearance Elements 软件中可视化 DOI / 清晰度**

1. **使用实时视图功能**，查看光泽相机的反射图像。
2. **切换至光泽相机模式**（使用切换相机图标）。
3. **使用自动曝光优化测量**，确保光源反射适中。
4. **如有需要，可手动调整曝光**，提高测量精度。
5. **调整镜面光源、线光源或聚光灯**，优化反射图像的清晰度。

**软件将显示 DOI / 清晰度测量值，并提供可视化反射质量分析。**

---

## **如何优化表面影像清晰度和锐利度**

### 提高影像清晰度和锐利度的方法
1. **提升表面光滑度**
    - 使用**更精细的抛光或打磨技术**，减少微观纹理影响。

2. **优化涂层配方**
    - **调整流平性和流动性**，使涂层更均匀铺展，减少表面不均。

3. **改进喷涂方法**
    - 调整喷涂**角度、压力和喷嘴大小**，避免**橘皮效应**或表面纹理缺陷。

4. **优化固化条件**
    - **控制涂层固化时间和环境因素（温度、湿度）**，确保表面均匀流平。

5. **使用高质量底漆或基材**
    - 基材的平整度直接影响涂层质量，优化基材可提高最终 DOI / 清晰度。

6. **塑料部件优化**
    - **优化注塑工艺**，减少表面缺陷，提高反射清晰度。

7. **使用流平助剂**
    - 在涂层中添加**流平助剂**，促进表面更光滑，提高 DOI / 清晰度。

---

**调整 DOI / 清晰度可能影响其他表面特性，因此优化时应综合考虑整体产品外观和性能。**
