# シャープネスとDOIの解釈

## **Distinctness of Image (DOI)スケール**

| DOI 単位   | 説明                                |
|----------|-----------------------------------|
| 0-50 %   | 反射画像が識別できない。                      |
| 50-70 %  | 低いDOI—反射画像がかろうじて見える。              |
| 70-90 %  | 中程度のDOI—明瞭な反射画像が見える。              |
| 90-95 %  | 高いDOI—非常に明瞭で鮮明な反射画像を示す。           |
| 95-100 % | 非常に高いDOI—極めてクリアでエッジが鋭く定義された反射を示す。 |

---

## **シャープネスとDOIとは何か？**

シャープネスとDOI（Distinctness of Image）は、表面の反射の明瞭さと定義性を定量化するための関連する測定値です。

### **シャープネス**
シャープネスは、反射画像内のエッジの明瞭さと定義性を評価します。
- シャープネスは0〜100 Sharpness Units (SU) のスケールで測定されます。
- 高い値は、よりクリアでシャープな反射を示します。

### **DOI (Distinctness of Image)**
DOIは、反射画像全体の明瞭さと鮮映度を評価します。
- 表面が歪みのない画像をどれだけ明確に反射できるかを定量化します。
- 高いDOI値は、より鮮明で歪みのない反射を示します。

---

## **Aesthetixによる測定方法**

### **シャープネス測定**
1. サンプル表面に反射した光源の高解像度画像をカメラセンサーで取得。
2. この反射画像内のエッジのシャープネスを分析。
3. 人間の視覚知覚と相関するシャープネス値を導出。

**DOI測定**
Aesthetixは、類似した画像ベースのアプローチを使用し、エッジシャープネスではなく反射画像全体の明瞭さを分析します。

---

## **比較と用途**

### **比較**
- シャープネスは、特に高品質な表面において、従来のDOI測定よりも感度が高く進んだ測定値です。
- シャープネスはエッジの明瞭さに焦点を当てており、人間の視覚知覚との相関が高いです。
- シャープネスは、非常に高品質な表面でDOIが見逃す可能性のある微妙な違いを検出できます。

### **用途**
- **シャープネス**: 高光沢や高品質な表面が関与する現代的な用途に推奨されます。
- **DOI**: 既存仕様や標準との互換性が必要な場合に使用されます。

---

## **Appearance Elementsでの可視化**

1. ライブビュー機能を使用してグロスカメラからデータを取得します。
2. カメラ切り替えアイコンでグロスカメラビューに切り替えます。
3. 自動露出機能を使用して、表面の反射率に合わせて最適化します。
4. 必要に応じて露出を手動調整します。
5. 鏡面光源やラインライト、スポットライトを制御して結果を確認します。

ソフトウェアでは、シャープネス/DOI値が表示され、反射画像品質の視覚的表現も提供されます。

---

## **Distinctness of Imageとシャープネスを向上させる方法**

1. **表面滑らかさの向上**: より細かな研磨やサンディング技術を適用します。
2. **コーティング配合の最適化**: より良い流動性と平滑性を促進する塗料配合を使用します。
3. **塗布方法の改善**: オレンジピールや他のテクスチャ問題を最小限に抑えるために塗布技術を改善します。
4. **適切な硬化条件**: コーティングが最適に平滑化するよう十分な乾燥条件を確保します。
5. **高品質な基材またはプライマー**: 滑らかな基礎層を作成します。
6. **プラスチック部品の場合**: 成形条件を最適化して表面欠陥を減少させます。
7. **流動添加剤**: コーティング内でレベリング効果を促進する添加剤を使用します。

<tip>シャープネス/DOI改善による他の表面特性への影響も考慮しながら調整してください。</tip>
