# 影像清晰度（DOI）

## **什么是影像清晰度（DOI）？**

**影像清晰度（Distinctness of Image, DOI）** 衡量的是**表面对图像的反射清晰度和锐利度**。

根据 **ASTM 定义**，DOI **用于评估反射图像的清晰度和锐利程度**，  
特别适用于**汽车涂层等对视觉质量要求极高的行业**。

- **高 DOI 值** → 表面可反射出**清晰、锐利的图像**，视觉质量优越。
- **低 DOI 值** → 反射图像模糊，通常由于表面存在**橘皮效应（Orange Peel）或其他不规则纹理**。

### 测量图像清晰度的方法
- DOI 测量最早在 **1950 年代**提出，  
  采用固定传感器**在特定角度测量反射光的扩散情况**。
- **光扩散范围较窄** → 反射图像**清晰**。
- **光扩散范围较宽** → 反射图像**模糊**。

**但在超高光泽表面上，传统 DOI 测量的灵敏度受传感器位置的限制**，  
清晰度测量（Sharpness）可更精准地适应不同表面反射特性。

---

## 图像清晰度数值及其意义

| DOI (%) | 反射图像描述                                 |
|---------|----------------------------------------|
| 0-35    | **极低清晰度**，反射图像高度模糊，边缘无法辨认。             |
| 35-60   | **低清晰度**，反射图像略有模糊，边缘开始可见。              |
| 60-85   | **中等清晰度**，边缘较为清晰，反射图像更加分明。             |
| 85-95   | **高清晰度**，反射图像非常清晰，边缘锐利。                |
| 95-100  | **极高清晰度**，反射图像极其清晰，边缘锐利且定义完美，达到镜面反射效果。 |

---

## **DOI 在橘皮效应（Orange Peel）测量中的局限性**

DOI 常被用于**间接量化涂层表面的橘皮效应**，但它存在一些局限性：
- **DOI 受表面微观纹理影响**，可能会因为**表面微观粗糙度**降低 DOI 值，  
  **即使橘皮效应并不存在**，也可能导致测量结果偏低。
- **DOI 无法用于非平面表面**，其测量精度在曲面上会受到限制。

✅ **如果需要更准确的橘皮效应测量，建议使用波纹度（Waviness）测量**，  
它能**更精确地量化大尺度表面起伏**，避免 DOI 的局限性。
