# Distinctness of Image (DOI)

**DOIとは何か？**

Distinctness of Image (DOI)は、表面が画像をどれだけ明瞭かつ鮮明に反射するかを測定する指標です。  
DOIは、特に自動車仕上げのような視覚品質が重要な分野で使用されます。

- **高DOI値**: 明瞭で歪みのない反射を示し、高品質の表面を意味します。
- **低DOI値**: 表面の不規則性（例: オレンジピールテクスチャ）によって反射がぼやけていることを示します。

DOIは、光が鏡面角からどのように拡散されるかを測定することで定量化されます。狭い拡散はシャープな画像を示し、広い拡散はぼやけた画像を示します。

---

 **DOIスケールとその意味**

| DOI %  | 説明                                  |
|--------|-------------------------------------|
| 0-35   | 非常に低いシャープネス—ぼやけた反射でエッジが不明瞭。         |
| 35-60  | 低いシャープネス—反射画像はややぼやけているが、エッジは識別可能。   |
| 60-85  | 中程度のシャープネス—エッジがより明瞭で、反射画像がはっきりしている。 |
| 85-95  | 高いシャープネス—非常に明確で鮮明なエッジを持つ反射画像。       |
| 95-100 | 非常に高いシャープネス—極めてクリアで鋭く定義されたエッジを持つ反射。 |

---

**DOIの限界とオレンジピールの定量化**

DOIは、塗装表面上のオレンジピール効果を間接的に定量化するために使用されてきました。しかし、以下のような欠点があります:
1. **他の表面効果**: 表面微細構造など、オレンジピール以外の要因でもDOIが低下する可能性があります。
2. **高品質表面への感度不足**: 高品質な表面では、わずかなオレンジピールではDOIにほとんど変化が見られないことがあります。

### **改善されたオレンジピール測定**
オレンジピールをより正確に評価するには、**ウェービネス (Waviness)** の測定が推奨されます。

---

**DOI測定の歴史**

1950年代には固定センサーを使用してDOI測定が行われ、光の広がり（拡散）を特定角度で測定しました。しかし、この方法には以下の制限があります:
- センサー配置の物理的制約により、高品質表面では感度が低下します。
- 非平坦な表面では適用できません。

---

**DOIとシャープネスの関係**

DOIとシャープネスはどちらも反射画像の明瞭さを評価しますが、それぞれ異なる側面に焦点を当てています:
- **DOI**: 全体的な反射画像の明瞭さと鮮映度。
- **シャープネス**: 特にエッジ部分の明瞭さと定義性。

<note>現在では、シャープネス測定がより感度が高く、人間の知覚と一致するため、高品質表面には推奨されています。</note>
