# RaeBinaryFile

The `RaeBinaryFile` is the root record for the RAE file format in its binary representation.

## Properties
- **Format** (required):  
  Identifies the data format contained within the file. For now, only `"MeasurementComponentMetaTuple[]"` is supported.

- **Version** (required):  
  Indicates the version of the file format. The current version is `1`.

- **Compression** (optional):  
  Specifies the compression algorithm used for the `Data` byte array. If not set, it defaults to `"none"`. Currently, only `"gzip"` is supported.

- **EncryptionAlgorithm** (optional):  
  Specifies the encryption algorithm applied to the data (if any). This is not implemented in the current version.

- **HashAlgorithm** (optional):  
  Describes the hashing algorithm used to validate data integrity. For example, `sha256`.

- **Hash** (optional):  
  A hash string used for data integrity checks. This is calculated using the algorithm specified in `HashAlgorithm`.

- **DataContainer** (required):  
  Indicates the format of the data inside the file after decompression. Currently, this must be `"MeasurementComponentMetaTuple[]"`.

- **DataSize** (required):  
  The size of the `Data` byte array in bytes.

- **Data** (required):  
  The actual measurement data stored as a byte array. The data is compressed using the specified compression algorithm (or left uncompressed if `Compression = "none"`) and contains a CBOR-encoded container matching the `Format`.


## Declaration
