# RAE File Format

The RAE file format is an open and flexible format to transport any kind of measurement.

It consists of three main parts:
- The "magic string" at the beginning of the file for file identification.
- The container properties (the file header)
- The actual data.

The data containers are RFC 8949 Concise Binary Object Representation (CBOR) encoded (<https://cbor.io/>, <https://en.wikipedia.org/wiki/CBOR>). \
CBOR is a compact, efficient binary serialization format, designed to be easily parsed and interoperable. It is ideal for transmitting structured data. \
There are a lot of free implementations for reading/writing CBOR for every widely used programming language like C#, C++, Java, or TypeScript: <https://cbor.io/impls.html>

- [File Identification](File-Identification.md)
- [MIME Type](MIME-Type.md)
- [File Header](File-Header.md)

