# Polishing Quality Module

 An advanced tool to quantifies surface defects such as scratches, holograms, and swirls on high-gloss finishes.

It simultaneously measures gloss, haze, sharpness, DOI, and orange peel, providing a comprehensive evaluation of surface quality.

This feature is invaluable to coatings manufacturers assessing abrasion resistance, polishing material producers benchmarking product effectiveness, or OEM car manufacturers optimizing polishing processes and evaluating spot repairs.

## Polishing Module Tools

### Gloss
Gloss is the standard measurement for reflective appearance but should not be used for optimizing the polishing process.
It is insensitive to imperfections such as scratches, swirls, and haze, which detract from a surface's visual appeal.

[Go to Gloss Section](Standard-Gloss-Measurement.md)


### Haze
Haze refers to the scattering of light by a surface, reducing the contrast of the reflected image and causing a milky appearance that diminishes the perceived depth of the finish.

It is caused by the nano-structure of the surface material, leading to near-specular reflections.

Haze can also result from weathering or oxidation of high-gloss paint. Measuring haze before polishing can help quantify the effectiveness of a paint correction process.

During the polishing process, haze is introduced using large grit size compounds then reduced and eliminated in subsequent steps as the grit size of the polish is reduced.
Haze measurement allows manufacturers to benchmark the performance of polishing compounds and materials and optimize both polishing time and technique.

In conjunction with physical test instruments haze measurement is an effective and sensitive measurement of abrasion and car wash resistance of high gloss coatings.

The preferred Aesthetix parameters used to measure this process are Log Haze Compensated (LogH C) or Visual Haze Outdoor (VisHH-in)).

[Go to Haze Section](Haze.md)

### Polishing Defect Profiling
The Polishing Quality Module quantifies linear defects on the surface of the paint, such as holograms, scratches, and polishing marks, using a high-intensity light source. The severity of these defects is assessed based on their size and length.

The defects are detected because they reflect light from the high intensity light source and appear bright against the background, this modules is only suitable for polishing defects which are brighter than than the background when illuminated.

Measuring these defects is important for OEM polishing quality- due to the low visibility of these defects in standard light these can be overlooked during repairs or polishing  in factory, first seen only to be seen by the customer in sunny condition.

