# 抛光质量模块（Polishing Quality Module）

用于高级量化高光表面上的缺陷，如划痕、全息纹和旋纹。

该模块可同时测量光泽度、雾影、清晰度、DOI（影像清晰度）和桔皮效应，提供全面的表面质量评估。

此功能对涂料制造商评估耐磨性、抛光材料生产商对比产品效果，以及OEM汽车制造商优化抛光工艺和评估局部修复效果具有重要价值。

---

## 抛光质量模块工具

### 光泽度

光泽度是标准的表面反射测量参数，但不适用于优化抛光过程。  
它对划痕、旋纹和雾影等表面缺陷不敏感，而这些缺陷会影响表面的视觉美感。

[前往光泽度部分](Standard-Gloss-Measurement-zh.md)

---

### 雾影

雾影指的是表面对光的散射，降低了反射图像的对比度，并导致一种奶白色的外观，使表面看起来缺乏深度。

它主要由表面材料的纳米结构引起，导致近镜面反射。同时，雾影也可能由高光涂层的老化或氧化引起。在抛光前测量雾影，可以量化漆面修正过程的有效性。

在抛光过程中，使用大粒径抛光剂时会引入雾影，而在后续使用较小粒径抛光剂的步骤中，雾影被逐步减少甚至消除。  
雾影测量可帮助制造商评估抛光材料和化合物的性能，并优化抛光时间和工艺。

结合物理测试仪器，雾影测量可以作为评估高光涂层耐磨性和洗车耐受性的敏感指标。

**推荐用于该过程的 Aesthetix 评估参数：**
- **Log Haze Compensated (LogH C)**
- **Visual Haze Outdoor (VisHH-in)**

[前往雾影部分](Haze-zh.md)

---

### 抛光缺陷分析

**抛光质量模块**可量化涂层表面的线性缺陷，如全息纹、划痕和抛光痕迹，利用高强度光源进行检测。  
缺陷的严重程度基于其大小和长度进行评估。

该模块利用高亮度光源照射表面，缺陷区域因其对光的散射效果而显得**比背景更亮**，从而被检测出来。  
因此，该模块仅适用于**在照明下比背景亮的抛光缺陷**。

测量这些缺陷对于OEM抛光质量至关重要。  
由于这些缺陷在普通光照条件下不易察觉，可能在工厂修复或抛光后仍未被发现，直到客户在**阳光下**才注意到问题。
