# 研磨品質モジュール

本モジュールは、高光沢仕上げの表面に発生する**傷、ホログラム、スワールマーク**などの欠陥を定量的に評価する高度なツールです。

**光沢（Gloss）、ヘイズ（Haze）、シャープネス（Sharpness）、DOI（Distinction of Image）、オレンジピール（Orange Peel）**を同時に測定し、表面品質を包括的に評価します。

この機能は以下の用途において非常に有用です：
- **コーティングメーカー**による耐摩耗性の評価
- **研磨材メーカー**による製品の性能比較
- **OEM自動車メーカー**による研磨プロセスの最適化およびスポット修理の評価

---

## 研磨モジュールのツール

### 光沢（Gloss）
光沢は反射特性を測定する標準的な指標ですが、**研磨プロセスの最適化には適していません**。  
光沢測定は、表面の視覚的な美観を損なう**傷、スワールマーク、ヘイズ**などの欠陥には影響を受けにくいためです。

[光沢のセクションへ](Standard-Gloss-Measurement-ja.md)

---

### ヘイズ（Haze）
ヘイズとは、表面による光の散乱を指し、**反射画像のコントラストを低下させ、仕上がりの深みを損なう「白濁」した外観を引き起こす現象**です。

ヘイズは、**表面材料のナノ構造によって発生し、準鏡面反射を生じる**ことが原因となります。

また、高光沢塗装の**風化や酸化**によってもヘイズが発生することがあります。  
研磨前にヘイズを測定することで、**塗装補正プロセスの効果を定量化**できます。

#### 研磨プロセスにおけるヘイズ
- 研磨工程では、**粗いコンパウンドを使用することでヘイズが発生**し、その後の研磨ステップで研磨剤の粒度を細かくすることでヘイズを減少・除去します。
- ヘイズ測定は、**研磨材や研磨プロセスの性能を評価**し、**最適な研磨時間と技術の確立**に役立ちます。
- 物理試験装置と併用することで、高光沢コーティングの**耐摩耗性や洗車耐性の評価にも効果的**です。

**Aesthetixでこのプロセスを測定する際の推奨パラメータ**：
- **Log Haze Compensated（LogH C）**
- **Visual Haze Outdoor（VisHH-in）**

[ヘイズのセクションへ](Haze-ja.md)

---

### 研磨欠陥プロファイリング（Polishing Defect Profiling）
研磨品質モジュールは、高輝度光源を使用して**ホログラム、傷、研磨マーク**などの**線状の欠陥**を定量化します。  
欠陥の**深刻度は、欠陥のサイズと長さに基づいて評価**されます。

#### 欠陥の検出原理：
- 高輝度光源からの反射光によって欠陥が検出されます。
- 欠陥部分が背景より明るく見えるため、**照明下で背景よりも明るくなる研磨欠陥のみを検出可能**です。

#### OEMにおける研磨品質管理の重要性：
- 標準的な照明では、これらの欠陥は視認性が低いため、**工場での修理や研磨工程で見落とされる可能性があります**。
- しかし、屋外の明るい環境（特に晴天時）では、**顧客が初めて欠陥を目にする**ことになり、品質問題となる場合があります。
- そのため、OEMメーカーにとって、**研磨品質モジュールを用いた事前検査が非常に重要**です。
