# Metrics properties

## Meta properties

| Unique identifier | Property name    | Node        | Data type | Description                                                                                       |
|-------------------|------------------|-------------|-----------|---------------------------------------------------------------------------------------------------|
| MStr0001          | Batch            | generalInfo | string    | User-defined batch name.                                                                          |
| MStr0002          | Name             | generalInfo | string    | User-defined name of the measurement                                                              |
| MStr0003          | Comments         | generalInfo | string    | User-defined comments.                                                                            |
| MStr0005          | SourceIdentifier | generalInfo | string    | An identifier set by the measurement device or measurement agent. It must be unique, e.g. a GUID. |
| MStr0006          | ModuleIdentifier | generalInfo | string    | The identifier of the module from which the measurement was taken.                                |

## Measurement properties

| Unique identifier | Property name             | Name                                | Node/Group  | Data type      | Source property             | Unit/Format       | Description                                                      |
|-------------------|---------------------------|-------------------------------------|-------------|----------------|-----------------------------|-------------------|------------------------------------------------------------------|
| Img0001           | sampleImage               |                                     | generalInfo | image          | -                           | Bgr24             | An image users can save additionally with the measurement.       |
| Img0002           | scratchOverlay            |                                     | scratch     | image          | scratch_overlay             | Indexed8          | The overlay image that shows the detected scratches.             |
| Img0003           | scratchImage              |                                     | scratch     | image          | scratch_image               | Bgr24             | The surface image taken from the scratch module.                 |
| Img0004           | scratchVerticalOverlay    |                                     | scratch     | image          | scratch_vertical            | Indexed8          | The image overlay of the vertical scratches.                     |
| Img0005           | crossCutImage             |                                     | crossCut    | image          | cross_cut_image             | Bgr24             | The surface image taken from the cross cut module                |
| Img0006           | crossCutFullOverlay       |                                     | crossCut    | image          | cc_full_overlay             | Indexed8          | The cross cut overlay showing a perfect area used in comparison. |
| Img0007           | crossCutFoundOverlay      |                                     | crossCut    | image          | cc_found_overlay            | Indexed8          | The cross cut overlay of the undamaged sections.                 |
| Img0008           | surfaceImage              |                                     | generalInfo | image          | Sur_Image                   | Bgr24             | The image from the top surface camera with all ring LEDs on.     |
| Img0009           | sparkleAlbedoImage        |                                     | sparkle     | image          | sparkle_albedo              | 32bit float, grey | Image to display graininess.                                     |
| Img0010           | scratchHorizontalOverlay  |                                     | scratch     | image          | scratch_horizontal          | Indexed8          | The image overlay of the horizontal scratches.                   |
| Img0012           | cellOverlay               |                                     | texture     | image          | Cell_Overlay                | Indexed8          | The image overlay of the watershed.                              |
| Img0013           | wavinessImage             |                                     | waviness    | image          | waviness_image              | Bgr24             | Image from 0° camera with line LED on.                           |
| Img0014           | spotImage                 |                                     | generalInfo | image          | Spot_Image                  | Bgr24             | The image from the spot camera.                                  |
| ImgL0001          | ledSparkleImages          |                                     | sparkle     | imageList      | sparkle_reduced_n           | Bbr24             | The sparkle image array based on each ring LED.                  |
| ImgL0002          | ledSparkleOverlays        |                                     | sparkle     | imageList      | sparkle_overlay_n           | Indexed8          | The sparkle image array of overlays based on each ring LED.      |
| DT0001            | dateCreated               | Date                                | generalInfo | dateTime       |                             | UTC               |                                                                  |
| Str0001           | instrumentSn              | Instrument Serial Number            | generalInfo | string         | serial_number               |                   |                                                                  |
| Str0002           | crossCutClassAstm         | ASTM Class                          | crossCut    | string         | cross_cut_class_astm        |                   |                                                                  |
| Str0003           | crossCutClassIso          | ISO Class                           | crossCut    | string         | cross_cut_class_iso         |                   |                                                                  |
| Dbl0005           | scratchSelection          | SS                                  | scratch     | double         | scratch_selection           | μm                |                                                                  |
| Dbl0006           | glossValue                | Gloss 60°                           | gloss       | double         | gloss                       | GU                | Calibrated gloss value.                                          |
| Dbl0007           | visualGlossValue          | Visual Gloss 60°                    | gloss       | double         | visual_gloss                | P-GU              | Calibrated visual gloss result.                                  |
| Dbl0008           | sharpnessValue            | Sharpness                           | sharpness   | double         | sharpness                   | %                 | Calibrated sharpness value.                                      |
| Dbl0009           | loghaze                   | LogH                                | haze        | double         | loghaze                     | logHU             | Logarithmic haze value.                                          |
| Dbl0010           | logHazeCValue             | LogH C                              | haze        | double         | loghaze_c                   | logHU             | Logarithmic haze background compensated value.                   |
| Dbl0011           | hazeCValue                | Haze C                              | haze        | double         | haze_c                      | HU                | Haze background compensated value.                               |
| Dbl0012           | contrastHazeValue         | MC H                                | haze        | double         | contrast_haze               | HU                | Calibrated contrast haze value.                                  |
| Dbl0013           | mcDoi                     | DOI                                 | haze        | double         | mc_doi                      | %                 |                                                                  |
| Dbl0014           | visualContrastValue       | Visual Contrast                     | haze        | double         | visual_contrast             | %                 | Calibrated visual contrast value.                                |
| Dbl0015           | visualHazeIndoorsValue    | Visual Haze Indoors                 | haze        | double         | visual_haze_indoors         | VHU               | Visual haze value with indoor viewing conditions.                |
| Dbl0016           | visualHazeOutsideValue    | Visual Haze Outside                 | haze        | double         | visual_haze_outside         | VHU               | Visual haze value with outside viewing conditions.               |
| Dbl0017           | crossCutPercent           | X-Cut                               | crossCut    | double         | cross_cut_percent           | %                 |                                                                  |
| Dbl0018           | sparkleGraininess         | Graininess                          | sparkle     | double         | sparkle_graininess          |                   |                                                                  |
| Dbl0019           | cellAmplitude             | Cell Amplitude (Ca)                 | texture     | double         | cell_amplitude              | P-μm              |                                                                  |
| Dbl0020           | cellNumber                | Cell Number (Cn)                    | texture     | double/int     | cell_number                 | count             |                                                                  |
| Dbl0021           | cellSize                  | Cell Size (Cs)                      | texture     | double         | cell_size                   | mm²               |                                                                  |
| Dbl0022           | cellMax                   | Cell Max Size (CsMax)               | texture     | double         | cell_max                    | mm²               |                                                                  |
| Dbl0023           | cellMin                   | Cell Min Size (CsMin)               | texture     | double         | cell_min                    | mm²               |                                                                  |
| Dbl0024           | cellStdDev                | Cell Standard Deviation (CsDev)     | texture     | double         | cell_std                    | mm²               |                                                                  |
| Dbl0025           | hillSize                  | Hill Size (Hs)                      | texture     | double         | hill_size                   | mm²               |                                                                  |
| Dbl0026           | fillFactor                | Fill Factor (F)                     | texture     | double         | fill_factor                 | %                 |                                                                  |
| Dbl0027           | textureR                  | Reflectivity                        | texture     | double         | interior_r                  | arb'U             | Average reflectivity.                                            |
| Dbl0028           | textureRc                 | Ratio Hill/Value Reflectivity (RC)  | texture     | double         | interior_rc                 | arb'U             | Ratio of hill and valley reflectivity.                           |
| Dbl0029           | textureRv                 | Valley Reflectivity (RV)            | texture     | double         | interior_rv                 | arb'U             | Valley reflectivity.                                             |
| Dbl0030           | textureRh                 | Hill Reflectivity (RH)              | texture     | double         | interior_rh                 | arb'U             | Hill reflectivity.                                               |
| Dbl0031           | roughnessSa               | Sa Rough                            | texture     | double         | roughness_std               | P-µm              |                                                                  |
| Dbl0032           | watershedMorphology       | Feature Separation (FSep)           | texture     | double         | watershed_morphology        | pixels            |                                                                  |
| Dbl0033           | watershedSelectionPercent | Feature Selection Percentage (FSel) | texture     | double         | watershed_selection_percent | %                 |                                                                  |
| Dbl0034           | wavinessValue             | Waviness                            | waviness    | double         | waviness                    | WU                |                                                                  |
| Dbl0035           | pciWaviness               | PCI Waviness                        | waviness    | double         | pci_waviness                |                   |                                                                  |
| Dbl0036           | tension                   | Tension                             | waviness    | double         | tension                     |                   |                                                                  |
| DblL0001          | scratchLength             | Scratch Length                      | scratch     | doubleList     | scratch_length              |                   |                                                                  |
| DblL0002          | scratchVisibility         | Scratch Visibility                  | scratch     | doubleList     | scratch_vis                 |                   |                                                                  |
| DblL0008          | scratchLengthMean         | Scratch Length (Mean)               | scratch     | doubleList     | scratch_mean                |                   |                                                                  |
| DblL0009          | scratchCount              | Scratch Count                       | scratch     | doubleList     | scratch_count               | -                 |                                                                  |
| DblL0010          | scratchArea               | Scratch Area                        | scratch     | doubleList     | scratch_area                |                   |                                                                  |
| DblL0011          | scratchVisibilityMean     | Scratch Visibility (Mean)           | scratch     | doubleList     | scratch_vis_mean            |                   |                                                                  |
| DblL0003          | surfaceRgbMean            | Mean Surface Color                  | color       | doubleList     | surface_colour              | (R, G, B)         | Average color of surface.                                        |
| DblL0004          | sparkleDensity            | Sparkle Density                     | sparkle     | doubleList     | sparkle_density             |                   |                                                                  |
| DblL0005          | sparkleRgb45              | Mean Sparkle Color (45°)            | sparkle     | doubleList     | sparkle_rgb_45              | (R, G, B)         |                                                                  |
| DblL0014          | sparkleRgb10              | Mean Sparkle Color (10°)            | sparkle     | doubleList     | sparkle_rgb_10              | (R, G, B)         |                                                                  |
| DblL0006          | sparkleVisibilityMean     | Mean Sparkle Visibility             | sparkle     | doubleList     | sparkle_visibility_mean     |                   |                                                                  |
| DblL0007          | sparkleAreaMean           | Mean Sparkle Area                   | sparkle     | doubleList     | sparkle_area_mean           |                   |                                                                  |
| DblL0012          | sparkleMonochrome         | Sparkle Monochrome                  | sparkle     | doubleList     | sparkle_monochrome          |                   |                                                                  |
| DblL0013          | sparkleBrightnessMean     | Mean Sparkle Brightness             | sparkle     | doubleList     | sparkle_brightness_mean     |                   |                                                                  |
| DblLL0001         | sparkleVisibilityArray    | Sparkle Visibility Array            | sparkle     | doubleListList | sparkle_visibility_array    |                   |                                                                  |
| DblLL0002         | sparkleAreaArray          | Sparkle Area Array                  | sparkle     | doubleListList | sparkle_area_array          |                   |                                                                  |
| DblLL0003         | sparkleBrightnessArray    | Sparkle Brightness Array            | sparkle     | doubleListList | sparkle_brightness_array    |                   |                                                                  |
| DblLL0004         | sparkleHueArray           | Sparkle Hue Array                   | sparkle     | doubleListList | sparkle_hue_array           |                   |                                                                  |
| P0001             | comPixelCoord             | Centre of Mass                      | gloss       | point          | COM                         |                   |                                                                  |
| PA0001            | glossRoiCoords            | Gloss Region of Interest            | gloss       | pointList      | gloss_roi                   | x1,y1,x2,y2: int  | Position of area used for gloss calculation.                     |
| PA0002            | hazeTopRoiCoords          | Haze Top Region of Interest         | haze        | pointList      | haze_top_roi                | x1,y1,x2,y2: int  | Position of area used for top haze calculation.                  |
| PA0003            | hazeBottomRoiCoords       | Haze Bottom Region of Interest      | haze        | pointList      | haze_bottom_roi             | x1,y1,x2,y2: int  | Position of area used for bottom haze calculation.               |
| PA0004            | mcHazeTopRoiCoords        | MC Haze Top Region of Interest      | haze        | pointList      | mc_top_roi                  | x1,y1,x2,y2: int  | Position of area used for top contrast haze calculation.         |
| PA0005            | mcHazeCenterRoiCoords     | MC Haze Center Region of Interest   | haze        | pointList      | mc_roi                      | x1,y1,x2,y2: int  | Position of area used for center contrast haze calculation.      |
| PA0006            | mcHazeBottomRoiCoords     | MC Haze Bottom Region of Interest   | haze        | pointList      | mc_bottom_roi               | x1,y1,x2,y2: int  | Position of area used for bottom contrast haze calculation.      |
| Pd3D0001          | texture3DPlotData         | Texture 3D Plot Data                | texture     | plot3D         | -                           |                   |                                                                  |
| Pd3D0002          | gloss3DPlotData           | Gloss 3D Plot Data                  | gloss       | plot3D         | -                           |                   |                                                                  |
| -                 | -                         | Image Names                         | -           | stringList     | image_names                 |                   |                                                                  |

