# Metric groups

The API trigger endpoints require the metric group identifier to initiate a measurement.

## List of metric groups

| ID             | Description |
|----------------|-------------|
| cell           |             |
| contrastHaze   |             |
| crossCut       |             |
| gloss          |             |
| grit           |             |
| haze           |             |
| roughness      |             |
| scratchLinear  |             |
| scratchRadial  |             |
| sharpness      |             |
| sparkle        |             |
| spot           |             |
| surface        |             |
| visualContrast |             |
| visualGloss    |             |
| visualHaze     |             |
| waviness       |             |
| pciWaviness    |             |
| tension        |             |

## Parameters

Certain metric groups require parameters, which are explained here.

Sub-properties are separated by a dot (.).\
For example, `altitude_crop.center.x` and `altitude_crop.center.y` must be passed in the following format:

```json
{
  "altitude_crop": {
    "center": {
      "x": 42,
      "y": 42
    }
  }
}
```

## Parameters for "cell"

| Parameter                   | Data type | Unit | Description |
|-----------------------------|-----------|------|-------------|
| watershed_morphology        |           |      |             |
| watershed_selection_percent |           |      |             |
| invert_map                  |           |      |             |
| altitude_crop.width         |           |      |             |
| altitude_crop.height        |           |      |             |
| altitude_crop.center.x      |           |      |             |
| altitude_crop.center.y      |           |      |             |

## Parameters for "scratchLinear"

| Parameter           | Data type | Unit | Description     |
|---------------------|-----------|------|-----------------|
| scratch_selection   |           | µm   | Minimum length. |
| scratch_sensitivity |           |      |                 |
| spot_radius         |           |      |                 |

## Parameters for "scratchRadial"

| Parameter           | Data type | Unit | Description     |
|---------------------|-----------|------|-----------------|
| scratch_selection   |           | µm   | Minimum length. |
| scratch_sensitivity |           |      |                 |
| spot_radius         |           |      |                 |

## Parameters for "crossCut"

| Parameter                 | Data type   | Unit | Description                                                                                            |
|---------------------------|-------------|------|--------------------------------------------------------------------------------------------------------|
| crosscut.horizontal_lines |             |      |                                                                                                        |
| crosscut.vertical_lines   |             |      |                                                                                                        |
| crosscut.spacing          |             | mm   |                                                                                                        |
| crosscut.thickness        |             | mm   |                                                                                                        |
| crosscut.threshold        |             |      |                                                                                                        |
| crosscut.automatic        | bool        |      |                                                                                                        |
| crosscut.invert           | bool        |      | When coating in brighter than base.                                                                    |
| crosscut.corners          | integerList |      | (x1, y1, x2, y2, x3, y3, x4, y4) - 1 is top left, 2 is top right, 3 is bottom left, 4 is bottom right. |

