# MeasurementTypes

The `MeasurementTypes` enumeration defines the various types of components that can be represented within the RAE file format. This enum provides a structured way to classify components based on their format, structure, and purpose.

## MeasurementTypes Usage
The `MeasurementTypes` enum is used to classify and interpret measurement data within the RAE format. Depending on the type, the structure of the associated data and the parsing logic may differ. When working with this enum:
- Ensure the correct type is assigned based on the measurement data's format and purpose.
- Use type-specific processing methods to handle each measurement type appropriately.

## MeasurementTypes Values

### **Composite**
Represents a measurement that is composed of multiple sub-components. Each sub-component may itself be a specific `MeasurementType`, forming a hierarchical structure.

- **Example Use Case**:
    - A composite measurement where multiple attributes (e.g., color, gloss, texture) are recorded together.
    - A super-measurement or a collection of merged measurements that contain multiple measurements within a single container (e.g., multiple measurements of the same material).

### **Single**
Represents a single, standalone measurement value. This type is used when the measurement consists of a singular data point without any additional components or sub-structures.

- **Example Use Case**:
    - A single gloss or color value recorded during a measurement.

### **Continuous**
Represents a time-based continuous measurement, such as a stream of data points collected over time.

- **Example Use Case**:
    - A measurement of temperature or humidity sampled continuously over a fixed time interval.

### **Graph**
Represents a measurement that is stored as a series of data points that can be plotted on a graph. This type is typically used for measurements involving relationships between variables (e.g., X-Y data).

- **Example Use Case**:
    - Reflectance curves or spectrograph data where intensity values are plotted against wavelength.

### **File**
Represents a measurement that is stored as a file within the system. The file itself contains the measurement data in a specific format.

- **Example Use Case**:
    - A raw image or binary file containing data collected from a measurement device.

### **FileReference**
Represents a reference to an external file that contains measurement data. Instead of embedding the file directly, this type provides a pointer to its location.

- **Example Use Case**:
    - A database entry or a URL pointing to a file stored on a remote server or file system.

### **Array**
Represents a measurement that consists of an array of values. This type is used when multiple related measurements are grouped together in a linear structure.

- **Example Use Case**:
    - An array of measurements taken at different spatial positions, such as a grid of gloss measurements across a surface.

## Declaration