# MeasurementMeta

The `MeasurementMeta` class provides detailed information about a measurement. Below are the key properties:

## Properties
- **Identifier (`id: string?`)**:  
  A unique identifier for the meta-item (not the actual measurement). It is usually set by the database in which it is stored.

- **Version (`ver: int32?`)**:  
  The version of the meta-container.

- **SourceIdentifier (`srcId: string?`)**:  
  A unique identifier for the measurement. This is set by the client that creates the measurement. This field is identical to the `SourceIdentifier` of `MeasurementComponent`.

- **MeasurementIdentifier (`mId: string?`)**:  
  The unique identifier of the `MeasurementComponent` dataset. It is usually set by the database in which it is stored.

- **ModuleIdentifier (`modId: string?`)**:  
  Identifies the module that performed the measurement.

- **MeasurementType (`mType: MeasurementTypes?|string?`)**:  
  Specifies the type of the root `MeasurementComponent`, for example, `Composite`, `Single`, or `File`. See `MeasurementTypes` for more details.

- **Timestamp (`time: DateTime?|string?`)**:  
  The timestamp when the measurement was taken/saved.

- **SourceTimestamp (`srcTime: DateTime?|string?`)**:  
  The original timestamp from the source device or the agent taking the measurement.

- **Name (`name: string?`)**:  
  A descriptive name for the measurement.

- **Project (`proj: string?`)**:  
  The associated project for the measurement.

- **Batch (`bat: string?`)**:  
  The associated batch for the measurement.

- **Customer (`cust: string?`)**:  
  The customer related to the measurement.

- **Comments (`com: string?`)**:  
  Any comments or notes about the measurement.

- **Tags (`tag: string?`)**:  
  A list of tags to help categorize or identify the measurement.

- **SearchableText (`search: string?`)**:  
  A concatenated string of searchable text fields.

## Declaration

