# MeasurementComponent

The `MeasurementComponent` class describes the individual components of a measurement. Below are its key properties:

### MeasurementComponent Properties
- **Identifier (`id: string?`)**:  
  A unique identifier for the measurement-item. Usually set by the database in which it is stored.

- **Version (`ver: int32?`)**:  
  The version of the measurement component.

- **SourceIdentifier (`srcId: string?`)**:  
  A unique identifier for the measurement. This is set by the client that creates the measurement. This field is identical to the `SourceIdentifier` of `MeasurementMeta`.

- **Type (`type: MeasurementTypes?|string?`)**:  
  Specifies the type of the current `MeasurementComponent`, for example, `Composite`, `Single`, or `File`. See `MeasurementTypes` for more details.

- **Name (`name: string?`)**:  
  A descriptive name for the component. Usually used to name the concrete metric, for example `"gloss"` or `"visualGloss"`.

- **Timestamp (`time: DateTime?|string?`)**:  
  The timestamp when this component was created. It is usually set only in the root component

- **SourceTimestamp (`srcTime: DateTime?|string?`)**:  
  The original timestamp from the source device or the agent taking the measurement. It is usually set only in the root component

- **Data (`data: IMeasurementData?`)**:  
  Contains the raw or processed data container for this measurement component. Check `IMeasurementData` for more details.

- **Metadata (`meta: IMetadata<MeasurementComponent>?`)**:  
  Additional metadata for this component.

- **Source (`src: IMeasurementSource?`)**:  
  Details about the source of this measurement component (for example, device identifier or location). Check `IMeasurementSource` for more details.

- **Components (`comp`)**:  
  A list of sub-components that belong to this measurement. These form the substantial part of the composite structure

- **SourceSignature (`srcSig: string?`)**:  
  A signature generated by the source device.

- **Signature (`sig: string?`)**:  
  A signature created by the measuring agent or a third-party signature system.

## Declaration
