# Measure the Gloss of Curved Surfaces


Measuring curved surfaces is challenging due to beam distortion and positioning difficulties. The Rhopoint Aesthetix addresses these issues with its advanced optical design, small measurement beam size adaptors and interactive measurement feature.

## **Preparation**

1. **Adaptor Selection:**
    - Replace the standard flat surface adaptor with the curved surface/small parts adaptor, Novo-Curve Adaptor or custom 3D printed Jig. This adaptor reduces the beam size, making it suitable for curved surfaces.
    - To attach the adaptor:
        - Remove the standard adaptor by pulling it off (magnetically attached).
        - Attach the curved surface adaptor securely in its place.
2. **Calibration:**
    - Recalibrate the instrument after changing adaptors to ensure accurate measurements. Use the supplied calibration tile certified to meet traceability standards.
3. **Positioning Tools (Optional):**
    - For repeatable measurements on small or complex parts, use bespoke 3D-printed jigs or a laboratory stand. These tools help maintain consistent positioning during measurement.

---

## **Measurement Procedure**

### **Using the Curved Surface Adaptor**

1. **Instrument Placement:**
    - Use the interactive measurement feature to ensure that the measurement beam is centered on the reflection image. Misalignment can lead to inaccurate results.
3. **Measurement Execution:**
    - Press the measurement button once alignment is confirmed. The Aesthetix will capture data for gloss, haze, DOI, and other parameters simultaneously.

### **Non-Contact Measurement (Optional)**

For fragile or delicate surfaces:

1. Mount the Aesthetix on a height-adjustable stand or integrate it into a COBOT system. Ensure that the focal distance is maintained at 10 mm ± 0.5 mm from the target surface.
2. Follow steps for live alignment and execute measurements as described above.

---

## **Tips for Accurate Measurement**

- Avoid measuring surfaces with a radius smaller than 0.5 m using standard adaptors; always use the curved surface adaptor for such cases.
- For highly complex shapes, consider non-contact measurement methods combined with custom jigs or COBOT systems for precise alignment.
- Regularly calibrate the instrument to maintain accuracy, especially after changing adaptors or environmental conditions.


## **Applications**

The Rhopoint Aesthetix excels in industries requiring precision appearance control of curved components, such as:

- Automotive (e.g., chrome trims, high-gloss paint finishes)
- Medical devices (e.g., orthopedic implants)
- Consumer electronics (e.g., buttons, casings)
- Pharmaceuticals and confectionery (e.g., pills, candy coatings).

---

By following these steps and leveraging its advanced features, you can achieve reliable and repeatable measurements of curved surfaces with your Rhopoint Aesthetix instrument.
