# 曲面の光沢測定

曲面の測定は、ビームの歪みや位置合わせの困難さから挑戦的です。Rhopoint Aesthetixは、高度な光学設計、小型測定ビームサイズアダプター、およびインタラクティブ測定機能を備えることで、これらの問題に対応します。

---

## **準備**

1. **アダプターの選択:**
    - 標準の平面アダプターを、曲面/小型部品用アダプター、Novo-Curveアダプター、または特注3Dプリントジグに交換してください。このアダプターはビームサイズを縮小し、曲面に適したものにします。
    - アダプターの取り付け方法:
        - 標準アダプターを引き抜いて取り外します（磁気で取り付けられています）。
        - 曲面用アダプターをしっかりと取り付けます。

2. **校正:**
    - アダプターを変更した後は、計測器を再校正して正確な測定を保証してください。トレーサビリティ基準を満たす認定校正タイルを使用します。

3. **位置決めツール（オプション）:**
    - 小型または複雑な部品で再現性のある測定を行うには、特注3Dプリントジグや実験室用スタンドを使用してください。これらのツールは、測定中の一貫した位置決めを支援します。

---

## **測定手順**

### **曲面用アダプターを使用した測定**

1. **計測器の配置:**
    - インタラクティブ測定機能を使用して、測定ビームが反射画像の中心に位置していることを確認します。位置がずれると不正確な結果につながります。

2. **測定の実行:**
    - 位置合わせが確認されたら、測定ボタンを押します。Aesthetixは光沢、ヘイズ、DOI（鮮映度）などのパラメーターを同時に取得します。

---

### **非接触測定（オプション）**

壊れやすいまたは繊細な表面の場合:

1. Aesthetixを高さ調整可能なスタンドに取り付けるか、COBOTシステムに統合します。焦点距離が10 mm ± 0.5 mmで維持されていることを確認してください。
2. ライブ位置合わせ手順に従い、上記と同様に測定を実行します。

---

## **正確な測定のためのヒント**

- 半径が0.5 m未満の曲面は標準アダプターで測定しないでください。必ず曲面用アダプターをご使用ください。
- 非常に複雑な形状の場合、非接触測定方法と特注ジグまたはCOBOTシステムを組み合わせて正確な位置合わせを行ってください。
- アダプター変更後や環境条件が変化した場合には、計測器を定期的に校正してください。

---

## **適用分野**

Rhopoint Aesthetixは、曲面部品の精密な外観管理が求められる業界で優れた性能を発揮します:

- **自動車業界**（例: クロームトリム、高光沢塗装仕上げ）
- **医療機器**（例: 整形外科用インプラント）
- **消費者向け電子機器**（例: ボタン、ケース）
- **製薬および菓子業界**（例: 錠剤、キャンディーコーティング）

---

これらの手順に従い、高度な機能を活用することで、Rhopoint Aesthetix計測器を使用して信頼性が高く再現性のある曲面測定が可能になります。
