# MIME Type

The MIME type for the RAE file format is:  
`application/vnd.rhopoint.rae+binary`

A MIME (Multipurpose Internet Mail Extensions) type is a standardized way to describe the nature and format of a file's content. The assigned MIME type for the RAE file format indicates that it is a proprietary binary file created and managed by Rhopoint Instruments. Below is a breakdown of the MIME type components:

1. **`application`**:  
   This denotes that the RAE file is an application-specific binary file rather than text or multimedia content.

2. **`vnd.rhopoint`**:  
   The `vnd.` prefix specifies that this is a vendor-specific MIME type, followed by `rhopoint`, which identifies Rhopoint Instruments as the creator and maintainer of the format.

3. **`rae`**:  
   This refers to the specific file format name, "RAE," associated with Rhopoint's measurement system.

4. **`+binary`**:  
   The `+binary` suffix indicates that the file content is encoded in a binary format, as opposed to text-based formats like JSON or XML.

#### Usage
The MIME type `application/vnd.rhopoint.rae+binary` is critical for ensuring proper handling and identification of RAE files in various systems. It is used in the following scenarios:
- **File Transfer**: To specify the file type during HTTP communication (e.g., as the `Content-Type` or `Accept` header in REST APIs).
- **File Storage**: To associate the correct file type metadata with stored RAE files.
- **File Parsing**: To ensure applications recognize and process RAE files with the appropriate decoders and parsers.

By adhering to this MIME type, systems and software can reliably identify RAE files and process them correctly in accordance with Rhopoint's specifications.
