# MC Haze

## **ヘイズとは何か？**

ヘイズは、表面による光の散乱を指し、反射画像のコントラストを低下させます。その結果、ミルキーな外観となり、仕上げの深みが損なわれることがあります。

---

## **ミケルソンコントラストヘイズ (Michelson Contrast Haze - MC H, HU)**

**MC Hパラメータ**（ミケルソンコントラストヘイズ）は、Rhopoint Aesthetixにおける新しいヘイズ指標であり、ミケルソンコントラストに基づいています。

- **測定方法**: 鏡面ハイライトの輝度と隣接するオフスペキュラー領域の輝度差を定量化します。
- **利点**: この方法は、従来のヘイズ測定では見落とされがちな表面微細構造が視覚的なヘイズにどのように影響するかについて洞察を提供します。

MC Hパラメータは、鏡面反射領域（ハイライト信号）と近接するオフスペキュラー領域の信号を比較して計算されます。これにより、表面微細構造が視覚的なヘイズに与える影響をより深く理解することが可能です。

---

## **MC Hazeの重要性**

- **視覚的評価**: MC Hazeは、人間の知覚に基づいたより正確なヘイズ評価を提供します。
- **産業用途**: 自動車塗装、高光沢家具、粉体塗装など、表面品質が重要な業界で特に有用です。
- **技術的改善**: 従来の標準化されたヘイズ評価方法よりも、サンプルの曇り特性をより良く表現します。

---

## **測定プロセス**

1. **信号ライン分析**: MC Hazeは、画像内のソースアパーチャエッジ両側の信号ラインから計算されます。
2. **平均ピクセル信号**: 透明ゾーンと不透明ゾーンそれぞれで100ピクセル以上の平均信号値を取得し、それらを比較します。
3. **参照値との比較**: 鏡面グロス参照サンプル（透明ゾーン）のミケルソンコントラスト値を基準として使用します。

---

MC Hazeは、従来の方法では捉えきれない表面特性を評価するための革新的な指標であり、Rhopoint Aesthetixによる測定精度と視覚的品質評価に新たな価値を提供します。
