# 雾影（Haze）

**雾影**指的是**表面对光线的散射作用**，导致**反射图像对比度降低**，使表面呈现**乳白色朦胧感**，从而降低涂层的视觉深度。

![反射雾影示例](reflection-haze-examples.png)

---

## **影响雾影可见度的因素**

- **观察条件**：
    - **高强度镜面光源下雾影最明显**，例如使用**强力检验灯**或在**强烈阳光下观察**。
- **材料的背景颜色**：
    - **不同颜色的背景对雾影的可见性有影响**，深色背景的材料通常比浅色背景更容易显现雾影。

**雾影会降低高光涂层的视觉质量，通常被视为不良特性。**

---

## **LogH C（补偿对数雾影值）**

**LogH C（LogHU）** 是 **Rhopoint Aesthetix** 计算的**对数雾影值**，基于**对比度测量**得出。

- **LogH C 具有背景颜色补偿功能**，可用于**消除颜色对雾影测量的影响**，因此**广泛应用于质量控制（QA）**。
- **Aesthetix 的 LogH C 测量值** 与 **Rhopoint IQ** 测量值**高度相关**。
- **测量方法**：
    - 采用 **60° 测量角度**（区别于传统的 20°）。
    - **雾影测量区域**定义在**偏离镜面反射角 2° 至 4° 的范围**。

---

## **LogH（对数雾影值）**

**LogH** 也是**从雾影测量计算出的对数值**，其计算方法遵循 **ASTM E430** 和 **ISO 13803** 标准：

- 该标准**基于镜面反射区域的光通量与偏离镜面区域光通量的比值**来评估雾影。
- **Aesthetix 采用 60° 角测量雾影值**，与传统 20° 角方法不同。

> **注意**：LogH 值**受背景颜色影响**，因此**不再用于质量控制（QC）**。

---

## **MC H（Michelson 对比雾影值）**

**Michelson 对比雾影值（MC H，HU）** 是基于 **Michelson 对比度** 计算的雾影参数。  
该方法可用于分析**传统雾影测量未能体现的表面微结构影响**。

- **计算方式**：
    - 量化**镜面高光亮度**与**相邻偏离镜面区域亮度**的差异。
    - 提供更深入的**表面微观结构对视觉雾影影响**的分析。

**MC H 可用于更全面地理解光泽表面雾影的成因，提供比传统雾影测量更丰富的信息。**
