# ヘイズ (Haze)

ヘイズとは、表面による光の散乱を指し、反射された画像のコントラストを低下させます。その結果、ミルキーな外観となり、仕上げの深みが損なわれることがあります。

![反射ヘイズの例](reflection-haze-examples.png)
<sup>反射ヘイズの例</sup>

ヘイズの視認性は、観察条件や材料の背景色によって影響を受けます。

- **観察条件**: ヘイズ効果は、高強度の鏡面光（例: 強力な検査ライトや明るい日差しの下）で観察すると非常に顕著です。
- **背景色**: ヘイズは高光沢コーティングの知覚品質を低下させるため、通常は望ましくない特性とされています。

---

## **ログヘイズ補正 (Log Haze Compensated - LogH C, LogHU)**

Rhopoint AesthetixにおけるLogH Cパラメータは、コントラストベースの測定を使用して計算された対数ヘイズ値を表します。

- **補正されたLogH C**: 背景色の影響を補正することで、異なる色の表面間で一貫した測定が可能になります。このため、品質管理（QA）アプリケーションで広く使用されます。
- **測定方法**: Aesthetixでは、従来の20°ではなく60°測定角度を使用し、鏡面角から2°～4°オフスペキュラー角度内の領域をヘイズ領域として定義します。

---

## **ログヘイズ (Log Haze - LogH)**

Rhopoint AesthetixにおけるLogHパラメータは、ヘイズ測定プロセスから導出されます。これは、ヘイズ値を対数スケールに変換して計算されます。

- **基準**: ASTM E430およびISO 13803規格に基づき、鏡面グロス参照サンプルからの光束とオフスペキュラー領域内の光束比率を使用して評価されます。
- **注意点**: Log H値は塗料の背景色に影響されるため、現在ではQCアプリケーションでは使用されていません。

---

## **ミケルソンコントラストヘイズ (Michelson Contrast Haze - MC H, HU)**

MC Hパラメータ（ミケルソンコントラストヘイズ）は、Rhopoint Aesthetixにおける新しいヘイズ指標であり、ミケルソンコントラストに基づいています。

- **特徴**: 鏡面ハイライトと隣接するオフスペキュラー領域の輝度差を定量化します。
- **利点**: 従来のヘイズ測定では見落とされがちな表面微細構造が視覚的なヘイズにどのように影響するかについて洞察を提供します。
- **測定方法**: 60°測定角度で取得した画像データを使用し、透明および不透明な領域間の輝度差を計算します。

---

## **重要性**

- ヘイズは高光沢コーティングや磨かれた金属表面で品質評価に重要な役割を果たします。
- 背景色や観察条件によって視認性が変化するため、適切な補正と測定が必要です。
