# Haze measurement tips

Tips on which Haze metric works to use to characterise a surface, when to use Haze or Visual Haze.

## Measurement Advice- Which Haze Metric should I use for my surface
LogH C is the most commonly used QC metric for paints and coatings.

For automotive polishing and finesse application visual hase indoor VisHin (VHU) and VisHout (VHU) are recommended.

## Measurement Advice- Which surfaces are suitable for Haze Measurement
Haze measurement is designed for high gloss surfaces, haze is quantified by measuring the amount of light reflected near the gloss angle.

Matt and semi gloss surfaces have a high reflection of light in this region because of their diffuse nature- this wiil show as a high haze reading but this will not match the perception of the surface.

## Measurement Advice – Haze Directionality

The haze measurements taken with the Rhopoint Aesthetix are **directional**, meaning haze is quantified specifically within the plane of measurement. This characteristic makes the instrument particularly sensitive to surface patterns or textures introduced during manufacturing.

### Why Directionality Matters
During production, many materials develop directional characteristics due to:

- **Printing processes** (e.g., lithographic varnishes)
- **Mechanical treatments** (e.g., rolling or polishing for stainless steel)
- **Environmental influences** (e.g., gravity effects in painted surfaces)

### How to Detect Directionality
To assess whether a material has directional properties:

1. **Perform the first measurement** in the standard orientation.
2. **Rotate the instrument 90°** and repeat the measurement.
3. **Compare the results**:
   - **Isotropic surfaces** (no directionality) will yield similar haze measurements regardless of orientation.
   - **Anisotropic surfaces** (directional) will show significant differences between the two measurements.

### Practical Importance
Understanding haze directionality helps maintain consistent appearance, especially for materials where surface texture is a critical aesthetic feature, like brushed metal or patterned coatings. Manufacturers can use this information to ensure uniformity across production batches or to deliberately enhance the directional characteristics for specific applications.

## Causes of Reflection Haze in a Surface
1. Surface Roughness and Texture
   - Microscopic Irregularities: Small-scale surface roughness and microscopic irregularities scatter light in various directions, causing a diffuse reflection. This scattering creates a hazy appearance around the main reflection.
   - Physical Texture: Surfaces with physical textures, such as fine scratches or uneven coatings, can scatter light and contribute to haze.
2. Contaminants and Impurities
   - Dust and Particles: Presence of dust, dirt, or other particles on the surface can scatter incident light, leading to haze.
   - Chemical Residues: Residues from cleaning agents, polishing compounds, or manufacturing processes can leave behind films or particles that scatter light.
3. Coating and Material Defects
   - Inhomogeneous Coatings: Variations in the thickness or composition of coatings can create regions that scatter light differently, increasing haze.
   - Material Inclusions: Embedded particles or inclusions within the material or coating can scatter light and contribute to a hazy reflection.
4. Subsurface Imperfections
   - Internal Scattering: Imperfections beneath the surface, such as air bubbles, voids, or subsurface cracks, can scatter light internally and cause haze.
   - Layer Interfaces: Interfaces between different layers of a coating or composite material can reflect and scatter light, contributing to haze.
5. Degradation and Wear
   - Aging and Weathering: Environmental exposure, UV light, and aging can degrade the surface quality, increasing roughness and promoting light scattering.
   - Mechanical Wear: Repeated mechanical actions, such as cleaning, polishing, or abrasion, can introduce surface defects that scatter light and increase haze.
