# Haze Interpretation

## What is Haze?

Haze refers to the scattering of light by a surface that causes a reduction in the contrast of a reflected image. It results in a milky appearance which can reduce the perceived depth and clarity of a finish[^1]. Haze is often caused by microscopic surface irregularities, contaminants, coating defects, or subsurface imperfections that scatter light in various directions[^1].

## How Aesthetix Measures Haze

The Aesthetix measures haze using an advanced imaging technique:

1. It captures a high-dynamic-range (HDR) image of the surface reflection
2. The system analyzes the light distribution around the main specular reflection
3. It quantifies the amount of scattered light in specific angular regions

This method allows for a more comprehensive assessment of haze compared to traditional haze meters.

## Haze Metrics Provided by Aesthetix

The Aesthetix provides several haze-related metrics:

1. LogH (LogHaze): Logarithmic haze value in logHU
2. LogH C: Logarithmic haze with background compensation in logHU
3. Haze C: Haze with background compensation in HU
4. MC H (Contrast Haze): Calibrated contrast haze value in HU
5. Visual Haze Indoors: Visual haze value for indoor viewing conditions in VHU
6. Visual Haze Outside: Visual haze value for outdoor viewing conditions in VHU

### Comparison and Usage

- LogH and LogH C provide logarithmic scales, which can be useful for materials with a wide range of haze values.
- Haze C and MC H offer linear scales with background compensation, providing more accurate results for colored or textured surfaces.
- Visual Haze metrics (Indoors and Outside) are perception-based measurements that correlate closely with human observation under different lighting conditions.

For most applications, Visual Haze metrics are recommended as they best represent how haze is perceived by human observers. Use Visual Haze Indoors for products primarily viewed indoors, and Visual Haze Outside for products exposed to outdoor lighting[^1].

For technical or research applications where comparison to traditional haze measurements is needed, LogH or Haze C may be more appropriate.

## Visualizing Haze in Appearance Elements


## Altering Surface Haze

To alter the haze of a surface:

1. Surface Polishing: Fine polishing can reduce surface irregularities and decrease haze.
2. Coating Formulation: Adjust the coating formula to include additives that promote smoother surface formation or reduce micro-texture.
3. Application Technique: Optimize spray patterns, drying conditions, and curing processes to minimize surface irregularities during coating application.
4. Surface Cleaning: Thoroughly clean the surface to remove contaminants that may contribute to haze.
5. Substrate Preparation: Ensure the underlying substrate is smooth and free of defects that could telegraph through the coating.
6. Post-Treatment: For some materials, post-application treatments like heat or UV curing can help reduce haze by promoting better surface leveling.
7. Environmental Control: Control humidity and temperature during application and curing to prevent issues like blushing that can increase haze.

Remember that altering haze may affect other surface properties, so consider the overall impact on the product's appearance and performance when making changes.