# 雾影解析

## **什么是雾影？**

**雾影**是指**表面对光线的散射作用**，导致**反射图像的对比度下降**，使表面呈现**乳白色朦胧感**，从而降低涂层的**视觉深度和清晰度**。

雾影通常由**微观表面不规则性、污染物、涂层缺陷或内部结构缺陷**导致，这些因素使光线向不同方向散射。

---

## **Rhopoint Aesthetix 如何测量雾影？**

Aesthetix 采用**先进的成像技术**进行雾影测量：

1. **捕捉高动态范围（HDR）表面反射图像**
2. **分析镜面反射区域周围的光分布**
3. **计算特定角度范围内的散射光量**

这种方法相比传统雾影计，可提供更全面的雾影评估。

---

## **Aesthetix 提供的雾影测量参数**

Aesthetix 提供多个雾影测量指标：

1. **LogH（对数雾影值）**：以 logHU 计算的对数雾影值
2. **LogH C（补偿对数雾影值）**：带背景颜色补偿的对数雾影值（logHU）
3. **Haze C（补偿雾影值）**：带背景颜色补偿的线性雾影值（HU）
4. **MC H（对比雾影值）**：基于 **Michelson 对比度** 计算的标准化雾影值（HU）
5. **视觉雾影（室内）**：适用于**室内观察条件**的视觉雾影值（VHU）
6. **视觉雾影（室外）**：适用于**户外照明环境**的视觉雾影值（VHU）

### **雾影测量参数对比及应用建议**

- **LogH 和 LogH C**：适用于**大范围雾影值的对数标度分析**。
- **Haze C 和 MC H**：提供**背景颜色补偿**，适用于**彩色或纹理表面**的精确测量。
- **视觉雾影（VHU）**：
    - **视觉雾影（室内）**（Visual Haze Indoors）：适用于**主要在室内使用的产品**。
    - **视觉雾影（室外）**（Visual Haze Outside）：适用于**暴露于户外光照的产品**。

对于大多数应用，**推荐使用视觉雾影（VHU）**，因为它能**最佳匹配人眼的实际感知**。  
**如果需要与传统雾影测量方法对比，则 LogH 或 Haze C 更合适。**

---

## **在 Appearance Elements 软件中可视化雾影**

---

## **如何降低表面雾影？**

要减少表面的雾影，可采取以下措施：

1. **表面抛光**
    - 精细抛光可**减少表面微观不规则性**，降低雾影值。

2. **优化涂层配方**
    - 在涂层中**添加促进表面平滑的添加剂**，减少微观纹理。

3. **改善涂覆工艺**
    - **优化喷涂方式、干燥条件和固化过程**，避免表面不均匀问题。

4. **表面清洁**
    - **去除污染物**（如灰尘、油污），减少因污染物导致的光散射。

5. **基材处理**
    - 确保**底材平滑**，避免基材缺陷**透过涂层影响雾影**。

6. **后处理技术**
    - 采用**热处理或 UV 固化**，改善表面平整度，减少雾影。

7. **环境控制**
    - 控制涂覆过程中的**温湿度**，防止因**湿度过高**导致的**泛白现象**增加雾影。

**请注意，调整雾影可能会影响其他表面性能**，因此在优化雾影时，应**综合考虑产品整体外观和功能表现**。
