# 光泽度解析

## 光泽值及其含义

光泽度以**光泽单位（GU）**进行测量。以下是不同材料的典型 60° 光泽值：

| 材料                 | 60° 光泽值（GU） |
|:---------------------|:----------------|
| 汽车清漆             | 85-95 GU        |
| 半光漆               | 50-75 GU        |
| 缎光漆               | 25-35 GU        |
| 哑光漆               | 5-15 GU         |
| 抛光金属             | 300-950 GU      |
| 完美镜面             | 1000 GU         |

**光泽值越高，表面反射率越强，光泽度越高。**

## 在 Appearance Elements 中可视化光泽度

## 调整表面光泽

要改变表面的光泽度，可采用以下方法：

1. **表面纹理**：表面越光滑，光泽度越高。
    - **抛光或打磨** 可提高光泽度，而**粗糙化处理** 会降低光泽度。

2. **涂层配方**：对于涂层表面，可**调整涂层的折射率**。
    - **较高折射率的材料** 通常具有更高的光泽度。

3. **颜料含量**：对于油漆而言，**颜料的种类和含量** 会影响光泽度。
    - **较少的颜料** 通常意味着更高的光泽度。

4. **涂覆方式**：不同的涂覆方法会影响最终的光泽效果。
    - **喷涂** 通常比**刷涂** 产生更高的光泽度。

5. **固化条件**：对于某些涂层，**固化过程** 直接影响最终光泽度。
    - **合适的固化条件** 对于实现期望的光泽度至关重要。

6. **基材影响**：基材的表面状况也会影响光泽度。
    - **较光滑的基材** 通常会带来更光亮的表面效果。

请注意，**调整光泽度可能会影响其他表面性能**，因此在优化光泽度时，应综合考虑对产品外观和性能的整体影响。
